<?php
// api.php
error_reporting(0); ini_set('display_errors', 0); header('Content-Type: application/json'); require_once 'config.php';
if (!isset($_SESSION['logado']) || $_SESSION['logado'] !== true) { die(json_encode(['success' => false, 'msg' => 'Sessão inválida', 'logout' => true])); }

$action = $_GET['action'] ?? ''; $type = $_GET['type'] ?? 'clientes';
$user_id = $_SESSION['user_id']; $is_admin = $_SESSION['is_admin'];
$filtro_clientes = $is_admin ? "" : " AND member_id = $user_id"; $filtro_revenda  = $is_admin ? "" : " WHERE owner_id = $user_id";

function verificarPosse($pdo, $id, $uid, $adm, $tabela) { if ($adm) return true; return ($pdo->query("SELECT " . ($tabela === 'reg_users' ? "owner_id" : "member_id") . " FROM $tabela WHERE id = $id")->fetchColumn() == $uid); }
function baixarArquivo($url) { $ch = curl_init(); curl_setopt($ch, CURLOPT_URL, $url); curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true); curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); curl_setopt($ch, CURLOPT_TIMEOUT, 300); curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0'); $res = curl_exec($ch); curl_close($ch); return $res; }
function buscarTMDB($titulo, $tipo) { if (!defined('TMDB_API_KEY') || empty(TMDB_API_KEY)) return ['cover' => '', 'plot' => '']; $tit = trim(preg_replace('/(\d{4}|1080p|720p|4k|dual|dublado|legendado|aac|h264|hevc|mkv|mp4|\(.*\)|\[.*\]|-|_)/i', '', $titulo)); $res = baixarArquivo("https://api.themoviedb.org/3/search/$tipo?api_key=" . TMDB_API_KEY . "&query=" . urlencode($tit) . "&language=pt-BR"); $data = json_decode($res, true); if (!empty($data['results'][0])) { $i = $data['results'][0]; return ['cover' => !empty($i['poster_path']) ? "https://image.tmdb.org/t/p/w500" . $i['poster_path'] : '', 'plot' => $i['overview'] ?? '']; } return ['cover' => '', 'plot' => '']; }
function atualizarLog($t, $a, $m) { file_put_contents('import_log.json', json_encode(['total' => $t, 'atual' => $a, 'msg' => $m])); }

try {
    if ($action === 'get_log') { if (file_exists('import_log.json')) echo file_get_contents('import_log.json'); else echo json_encode(['total' => 0, 'atual' => 0, 'msg' => 'Aguardando...']); exit; }

    // === SALVAR ORDEM CATEGORIAS (Corrigido) ===
    if ($action === 'salvar_ordem_categorias') {
        if (!$is_admin) die(json_encode(['success' => false, 'msg' => 'Acesso negado']));
        // A variável POST precisa ser a mesma que o JS envia ("ordem")
        $ordem = json_decode($_POST['ordem'] ?? '[]', true); 
        if (empty($ordem)) die(json_encode(['success' => false, 'msg' => 'Ordem Vazia']));
        
        $pdo->beginTransaction();
        try {
            $stmt = $pdo->prepare("UPDATE stream_categories SET cat_order = ? WHERE id = ?");
            foreach ($ordem as $item) { $stmt->execute([(int)$item['order'], (int)$item['id']]); }
            $pdo->commit(); 
            echo json_encode(['success' => true, 'msg' => 'Ordem salva! Recarregue a lista nos aplicativos.']);
        } catch (Exception $e) { 
            $pdo->rollBack(); 
            echo json_encode(['success' => false, 'msg' => 'Erro: ' . $e->getMessage()]); 
        } 
        exit;
    }

    if ($action === 'apagar_conteudos') {
        if (!$is_admin) die(json_encode(['success' => false, 'msg' => 'Acesso negado']));
        $tipo_ex = $_POST['tipo_exclusao'] ?? '';
        if ($tipo_ex === 'tudo') { $pdo->exec("TRUNCATE TABLE stream_categories"); $pdo->exec("TRUNCATE TABLE streams"); $pdo->exec("TRUNCATE TABLE series"); echo json_encode(['success' => true, 'msg' => 'TUDO APAGADO!']); exit; } 
        if ($tipo_ex === 'selecionados') {
            $cats = json_decode($_POST['categorias'] ?? '[]'); if (empty($cats)) die(json_encode(['success' => false, 'msg' => 'Selecione categorias.']));
            $in = implode(',', array_map('intval', $cats)); $pdo->exec("DELETE FROM streams WHERE category_id IN ($in)"); $pdo->exec("DELETE FROM series WHERE category_id IN ($in)"); $pdo->exec("DELETE FROM stream_categories WHERE id IN ($in)"); echo json_encode(['success' => true, 'msg' => 'Excluído com sucesso!']); exit;
        }
    }

    if ($action === 'ler_m3u') {
        if (!$is_admin) die(json_encode(['success' => false, 'msg' => 'Acesso negado']));
        ini_set('memory_limit', '-1'); set_time_limit(0); $url = $_POST['url_m3u'] ?? ''; $conteudo = baixarArquivo($url);
        if (!$conteudo) die(json_encode(['success' => false, 'msg' => 'Falha.'])); preg_match_all('/group-title="([^"]+)"/i', $conteudo, $m);
        if (empty($m[1])) die(json_encode(['success' => false, 'msg' => 'Sem categorias.'])); $cats = array_values(array_unique($m[1])); sort($cats); echo json_encode(['success' => true, 'data' => $cats]); exit;
    }

    if ($action === 'importar_m3u') {
        if (!$is_admin) die(json_encode(['success' => false, 'msg' => 'Acesso negado']));
        ini_set('memory_limit', '-1'); set_time_limit(0); $url = $_POST['url_m3u'] ?? ''; $cats_sel = json_decode($_POST['categorias'] ?? '[]');
        if (empty($cats_sel)) die(json_encode(['success' => false, 'msg' => 'Nenhuma categoria selecionada.']));
        atualizarLog(0, 0, "Baixando..."); $conteudo = baixarArquivo($url); if (!$conteudo) die(json_encode(['success' => false, 'msg' => 'Falha.']));
        $linhas = explode("\n", $conteudo); $total = count($linhas); $item_atual = []; $qtd = 0; $cache_tmdb = []; $cache_db = [];
        $stmtCat = $pdo->prepare("INSERT INTO stream_categories (category_type, category_name, parent_id) VALUES (?, ?, 0)"); $stmtMovie = $pdo->prepare("INSERT INTO streams (type, category_id, stream_display_name, stream_source, stream_icon, movie_propeties, target_container) VALUES (2, ?, ?, ?, ?, ?, ?)"); $stmtLive = $pdo->prepare("INSERT INTO streams (type, category_id, stream_display_name, stream_source, stream_icon, target_container) VALUES (1, ?, ?, ?, ?, ?)"); $stmtSeries = $pdo->prepare("INSERT INTO series (title, category_id, cover, plot, releaseDate) VALUES (?, ?, ?, ?, NOW())"); $stmtEp = $pdo->prepare("INSERT INTO streams (type, category_id, stream_display_name, stream_source, stream_icon, movie_propeties, target_container, series_no) VALUES (5, ?, ?, ?, ?, ?, ?, ?)");
        for ($i = 0; $i < $total; $i++) {
            $linha = trim($linhas[$i]); if (empty($linha)) continue;
            if ($i % 50 === 0) atualizarLog($total, $i, "Processando: " . ($item_atual['name'] ?? '...'));
            if (strpos($linha, '#EXTINF') === 0) { preg_match('/group-title="([^"]+)"/i', $linha, $c); preg_match('/tvg-logo="([^"]+)"/i', $linha, $l); $p = explode(',', $linha); $item_atual = ['cat' => $c[1] ?? 'Sem Categoria', 'logo' => $l[1] ?? '', 'name' => trim(end($p))]; } 
            elseif (strpos($linha, 'http') === 0 && !empty($item_atual)) {
                if (in_array($item_atual['cat'], $cats_sel)) {
                    $nome = $item_atual['name']; $url_enc = json_encode([$linha]); $is_series = false; $season = 1; $ep = 1; $nome_s = $nome;
                    if (preg_match('/(?:S|T)\s*(\d{1,2})\s*(?:E|EP)\s*(\d{1,3})/i', $nome, $m) || preg_match('/(?:Season|Temporada)\s*(\d{1,2})\s*(?:Episode|Episodio|Ep)\s*(\d{1,3})/i', $nome, $m)) { $is_series = true; $season = (int)$m[1]; $ep = (int)$m[2]; $nome_s = trim(preg_replace('/(?:S|T)\s*\d{1,2}\s*(?:E|EP)\s*\d{1,3}.*$/i', '', $nome)); }
                    $tipo_cat = $is_series ? 'series' : (preg_match('/\.(mp4|mkv|avi|mov)$/i', $linha) ? 'movie' : 'live');
                    $cat_id = $pdo->query("SELECT id FROM stream_categories WHERE category_name = " . $pdo->quote($item_atual['cat']))->fetchColumn();
                    if (!$cat_id) { $stmtCat->execute([$tipo_cat, $item_atual['cat']]); $cat_id = $pdo->lastInsertId(); }
                    if ($is_series) {
                        if (!isset($cache_db[$nome_s])) { if (!isset($cache_tmdb[$nome_s])) $cache_tmdb[$nome_s] = buscarTMDB($nome_s, 'tv'); $tmdb = $cache_tmdb[$nome_s]; $capa = !empty($tmdb['cover']) ? $tmdb['cover'] : $item_atual['logo']; $stmtSeries->execute([$nome_s, $cat_id, $capa, $tmdb['plot']]); $cache_db[$nome_s] = $pdo->lastInsertId(); }
                        $sid = $cache_db[$nome_s]; $prop = json_encode(['season' => $season, 'episode' => $ep, 'plot' => $cache_tmdb[$nome_s]['plot'] ?? '']); $cont = preg_match('/\.(mp4|mkv|avi|mov)$/i', $linha, $cx) ? $cx[1] : 'mp4'; try { $stmtEp->execute([$cat_id, $nome, $url_enc, $item_atual['logo'], $prop, $cont, $sid]); $qtd++; } catch(Exception $e) {}
                    } else if ($tipo_cat === 'movie') {
                        $tmdb = buscarTMDB($nome, 'movie'); $capa = !empty($tmdb['cover']) ? $tmdb['cover'] : $item_atual['logo']; $prop = json_encode(['plot' => $tmdb['plot'] ?? '', 'movie_image' => $capa]); $cont = preg_match('/\.(mp4|mkv|avi|mov)$/i', $linha, $cx) ? $cx[1] : 'mp4'; try { $stmtMovie->execute([$cat_id, $nome, $url_enc, $capa, $prop, $cont]); $qtd++; } catch(Exception $e) {}
                    } else { try { $stmtLive->execute([$cat_id, $nome, $url_enc, $item_atual['logo'], '["apple"]']); $qtd++; } catch(Exception $e) {} }
                } $item_atual = []; 
            }
        } atualizarLog($total, $total, "Concluído! $qtd importados."); echo json_encode(['success' => true, 'msg' => "$qtd importados!"]); exit;
    }

    if ($action === 'dashboard_stats') {
        $now = time(); $c = function($q) use ($pdo) { return $pdo->query($q)->fetchColumn(); };
        echo json_encode(['success' => true, 'data' => ['clientes' => ['ativos' => $c("SELECT COUNT(id) FROM users WHERE is_trial = 0 AND enabled = 1 AND (exp_date > $now OR exp_date = 0 OR exp_date IS NULL) $filtro_clientes"), 'vencidos' => $c("SELECT COUNT(id) FROM users WHERE is_trial = 0 AND exp_date < $now AND exp_date > 0 $filtro_clientes"), 'bloqueados' => $c("SELECT COUNT(id) FROM users WHERE is_trial = 0 AND enabled = 0 $filtro_clientes")], 'testes' => ['ativos' => $c("SELECT COUNT(id) FROM users WHERE is_trial = 1 AND enabled = 1 AND (exp_date > $now OR exp_date = 0 OR exp_date IS NULL) $filtro_clientes"), 'vencidos' => $c("SELECT COUNT(id) FROM users WHERE is_trial = 1 AND exp_date < $now AND exp_date > 0 $filtro_clientes"), 'bloqueados' => $c("SELECT COUNT(id) FROM users WHERE is_trial = 1 AND enabled = 0 $filtro_clientes")], 'conteudo' => ['canais' => $c("SELECT COUNT(id) FROM streams WHERE type IN (1, 3)"), 'filmes' => $c("SELECT COUNT(id) FROM streams WHERE type = 2"), 'series' => $c("SELECT COUNT(id) FROM series")]]]); exit;
    }

    if ($action === 'get_categories') { 
        try { 
            $stmt = $pdo->query("SELECT id, category_name, category_type, cat_order FROM stream_categories ORDER BY category_type ASC, cat_order ASC, category_name ASC"); 
            echo json_encode(['success' => true, 'data' => $stmt->fetchAll(PDO::FETCH_ASSOC)]); 
        } catch(Exception $e){ 
            try { $stmt = $pdo->query("SELECT id, category_name, category_type FROM stream_categories ORDER BY category_type ASC, category_name ASC"); echo json_encode(['success' => true, 'data' => $stmt->fetchAll(PDO::FETCH_ASSOC)]); } catch(Exception $e2) { echo json_encode(['success' => true, 'data' => []]); }
        } exit; 
    }

    if ($action === 'get_bouquets') { echo json_encode(['success' => true, 'data' => $pdo->query("SELECT id, bouquet_name FROM bouquets ORDER BY bouquet_name ASC")->fetchAll(PDO::FETCH_ASSOC)]); exit; }

    if ($action === 'get') {
        $dados = [];
        if ($type === 'clientes') { $dados = $pdo->query("SELECT id, username, password, exp_date, enabled, bouquet FROM users WHERE is_trial = 0 $filtro_clientes ORDER BY id DESC LIMIT 200")->fetchAll(PDO::FETCH_ASSOC); } 
        elseif ($type === 'testes') { $dados = $pdo->query("SELECT id, username, password, exp_date, enabled, bouquet FROM users WHERE is_trial = 1 $filtro_clientes ORDER BY id DESC LIMIT 200")->fetchAll(PDO::FETCH_ASSOC); } 
        elseif ($type === 'revendedores') { $dados = $pdo->query("SELECT id, username, password, status as enabled, credits, email FROM reg_users $filtro_revenda ORDER BY id DESC LIMIT 200")->fetchAll(PDO::FETCH_ASSOC); } 
        elseif ($type === 'bouquets') { 
            if (!$is_admin) die(json_encode(['success' => false, 'msg' => 'Acesso negado'])); 
            $stmt = $pdo->query("SELECT id, bouquet_name, bouquet_channels, bouquet_series FROM bouquets ORDER BY id DESC"); 
            while ($r = $stmt->fetch(PDO::FETCH_ASSOC)) { 
                $strs = json_decode($r['bouquet_channels'], true) ?: []; $sers = json_decode($r['bouquet_series'], true) ?: []; $c_ids = []; 
                if(!empty($strs)) { $in=implode(',',$strs); try{ $c_ids=array_merge($c_ids, $pdo->query("SELECT DISTINCT category_id FROM streams WHERE id IN ($in)")->fetchAll(PDO::FETCH_COLUMN)); }catch(Exception $e){} } 
                if(!empty($sers)) { $in=implode(',',$sers); try{ $c_ids=array_merge($c_ids, $pdo->query("SELECT DISTINCT category_id FROM series WHERE id IN ($in)")->fetchAll(PDO::FETCH_COLUMN)); }catch(Exception $e){} } 
                $r['category_ids'] = array_values(array_unique($c_ids)); $dados[] = $r; 
            } 
        }
        echo json_encode(['success' => true, 'server_url' => (defined('SERVIDOR_URL') ? SERVIDOR_URL : ''), 'data' => $dados]); exit;
    }

    if ($action === 'save') {
        $id = $_POST['id'] ?? '';
        if ($type === 'bouquets') {
            if (!$is_admin) die(json_encode(['success' => false, 'msg' => 'Acesso negado']));
            $bouquet_name = $_POST['bouquet_name'] ?? ''; $cats = $_POST['categorias'] ?? []; $canais_filmes = []; $series_ids = [];
            if (!empty($cats)) { $in = implode(',', array_map('intval', $cats)); try { $canais_filmes = $pdo->query("SELECT id FROM streams WHERE category_id IN ($in)")->fetchAll(PDO::FETCH_COLUMN); $series_ids = $pdo->query("SELECT id FROM series WHERE category_id IN ($in)")->fetchAll(PDO::FETCH_COLUMN); } catch(Exception $e){} }
            $b_channels = json_encode(array_map('intval', $canais_filmes)); $b_series = json_encode(array_map('intval', $series_ids));
            if (empty($id)) { $stmt = $pdo->prepare("INSERT INTO bouquets (bouquet_name, bouquet_channels, bouquet_series, bouquet_order) VALUES (?, ?, ?, 0)"); $stmt->execute([$bouquet_name, $b_channels, $b_series]); } else { $stmt = $pdo->prepare("UPDATE bouquets SET bouquet_name = ?, bouquet_channels = ?, bouquet_series = ? WHERE id = ?"); $stmt->execute([$bouquet_name, $b_channels, $b_series, $id]); }
            echo json_encode(['success' => true, 'msg' => 'Salvo com sucesso!']); exit;
        }
        if ($type === 'revendedores') {
            if (!empty($id) && !verificarPosse($pdo, $id, $user_id, $is_admin, 'reg_users')) die(json_encode(['success' => false, 'msg' => 'Sem permissão']));
            $username = $_POST['username'] ?? ''; $password = $_POST['password'] ?? ''; $email = $_POST['email'] ?? ''; $credits = $_POST['credits'] ?? 0;
            if (empty($id)) { $stmt = $pdo->prepare("INSERT INTO reg_users (username, password, email, credits, status, date_registered, member_group_id, owner_id) VALUES (?, ?, ?, ?, 1, ?, 2, ?)"); $stmt->execute([$username, $password, $email, $credits, time(), $user_id]); } else { $stmt = $pdo->prepare("UPDATE reg_users SET username = ?, password = ?, email = ?, credits = ? WHERE id = ?"); $stmt->execute([$username, $password, $email, $credits, $id]); }
            echo json_encode(['success' => true, 'msg' => 'Salvo com sucesso!']); exit;
        } 
        if ($type === 'clientes' || $type === 'testes') {
            if (!empty($id) && !verificarPosse($pdo, $id, $user_id, $is_admin, 'users')) die(json_encode(['success' => false, 'msg' => 'Sem permissão']));
            $username = $_POST['username'] ?? ''; $password = $_POST['password'] ?? ''; $is_trial = ($type === 'testes') ? 1 : 0;
            $vencimento_raw = $_POST['vencimento'] ?? ''; $exp_date = empty($vencimento_raw) ? null : strtotime($vencimento_raw . ' 23:59:59'); $bouquets = isset($_POST['bouquets']) ? json_encode(array_map('intval', $_POST['bouquets'])) : '[]';
            if (empty($id)) { $stmt = $pdo->prepare("INSERT INTO users (username, password, exp_date, enabled, is_trial, created_at, member_id, bouquet) VALUES (?, ?, ?, 1, ?, ?, ?, ?)"); $stmt->execute([$username, $password, $exp_date, $is_trial, time(), $user_id, $bouquets]); } else { $stmt = $pdo->prepare("UPDATE users SET username = ?, password = ?, is_trial = ?, exp_date = ?, bouquet = ? WHERE id = ?"); $stmt->execute([$username, $password, $is_trial, $exp_date, $bouquets, $id]); }
            echo json_encode(['success' => true, 'msg' => 'Salvo com sucesso!']); exit;
        }
    }

    if ($action === 'renew') { $id = $_POST['id']; if (!verificarPosse($pdo, $id, $user_id, $is_admin, 'users')) die(json_encode(['success' => false, 'msg' => 'Acesso negado'])); $stmt = $pdo->prepare("UPDATE users SET exp_date = ? WHERE id = ?"); $stmt->execute([strtotime("+".($_POST['meses'] ?? 1)." months"), $id]); echo json_encode(['success' => true, 'msg' => 'Renovado!']); exit; }
    if ($action === 'toggle') { $id = $_POST['id']; $tabela = ($type === 'revendedores') ? 'reg_users' : 'users'; if (!verificarPosse($pdo, $id, $user_id, $is_admin, $tabela)) die(json_encode(['success' => false, 'msg' => 'Acesso negado'])); $col = ($type === 'revendedores') ? 'status' : 'enabled'; $stmt = $pdo->prepare("UPDATE $tabela SET $col = ? WHERE id = ?"); $stmt->execute([($_POST['status'] == 1 ? 0 : 1), $id]); echo json_encode(['success' => true]); exit; }
    if ($action === 'delete') { $id = $_POST['id']; if ($type === 'bouquets') { if (!$is_admin) die(json_encode(['success' => false, 'msg' => 'Acesso negado'])); $stmt = $pdo->prepare("DELETE FROM bouquets WHERE id = ?"); } else { $tabela = ($type === 'revendedores') ? 'reg_users' : 'users'; if (!verificarPosse($pdo, $id, $user_id, $is_admin, $tabela)) die(json_encode(['success' => false, 'msg' => 'Acesso negado'])); $stmt = $pdo->prepare("DELETE FROM $tabela WHERE id = ?"); } $stmt->execute([$id]); echo json_encode(['success' => true]); exit; }

} catch (PDOException $e) { echo json_encode(['success' => false, 'msg' => 'Erro BD: ' . $e->getMessage()]); }
?>
