// app.js
let abaAtual = 'dashboard';
let dadosAtuais = []; 
let todosBouquets = [];
let todasCategorias = [];
let serverUrl = "";
let logIntervalo = null;

document.addEventListener('DOMContentLoaded', () => {
    const sidebar = document.getElementById('sidebar');
    const overlay = document.getElementById('sidebarOverlay');
    const toggleMenu = () => { sidebar.classList.toggle('-translate-x-full'); overlay.classList.toggle('hidden'); };
    document.getElementById('openSidebar').addEventListener('click', toggleMenu);
    document.getElementById('closeSidebar').addEventListener('click', toggleMenu);
    overlay.addEventListener('click', toggleMenu);
    carregarBouquets(); carregarCategorias(); carregarDados();
});

window.marcarTodos = (nomeInput, estado) => { document.querySelectorAll(`input[name="${nomeInput}"]`).forEach(cb => { cb.checked = estado; }); };

async function carregarBouquets() { try { const res = await fetch('api.php?action=get_bouquets'); const json = await res.json(); if(json.success) todosBouquets = json.data; } catch(e) {} }
async function carregarCategorias() { try { const res = await fetch('api.php?action=get_categories'); const json = await res.json(); if(json.success) todasCategorias = json.data; } catch(e) {} }

function mudarAba(novaAba) {
    abaAtual = novaAba;
    document.querySelectorAll('.nav-btn').forEach(btn => { btn.classList.remove('bg-blue-600', 'text-white', 'shadow-md'); btn.classList.add('text-gray-400', 'hover:bg-gray-800'); });
    const btnAtivo = document.getElementById(`btn-${novaAba}`);
    if(btnAtivo) { btnAtivo.classList.remove('text-gray-400', 'hover:bg-gray-800'); btnAtivo.classList.add('bg-blue-600', 'text-white', 'shadow-md'); }

    const titulos = { 'dashboard': 'Dashboard', 'clientes': 'Clientes Oficiais', 'testes': 'Testes', 'revendedores': 'Revendedores', 'bouquets': 'Bouquets', 'importador': 'Importar M3U', 'apagar': 'Apagar Conteúdos', 'organizar': 'Organizar Categorias' };
    document.getElementById('tituloPagina').innerText = titulos[novaAba] || 'Painel';

    if(window.innerWidth < 768) { document.getElementById('sidebar').classList.add('-translate-x-full'); document.getElementById('sidebarOverlay').classList.add('hidden'); }
    
    ['grid-cards', 'tela-importador', 'tela-apagar', 'tela-organizar'].forEach(id => { const el = document.getElementById(id); if(el) el.classList.add('hidden'); });
    ['btnNovoMobile', 'btnNovoDesktop', 'btn-recarregar'].forEach(id => { const el = document.getElementById(id); if(el) el.classList.add('hidden'); });

    if (abaAtual === 'importador') {
        document.getElementById('tela-importador').classList.remove('hidden');
    } else if (abaAtual === 'apagar') {
        document.getElementById('tela-apagar').classList.remove('hidden'); renderizarCategoriasApagar();
    } else if (abaAtual === 'organizar') {
        document.getElementById('tela-organizar').classList.remove('hidden'); renderizarOrganizacaoCategorias();
    } else {
        document.getElementById('grid-cards').classList.remove('hidden'); document.getElementById('btn-recarregar').classList.remove('hidden'); carregarDados();
    }
}

// === LÓGICA DE ORGANIZAR CATEGORIAS (DRAG & DROP) ===
function renderizarOrganizacaoCategorias() {
    const listLive = document.getElementById('sortable-live'); const listMovie = document.getElementById('sortable-movie'); const listSeries = document.getElementById('sortable-series');
    if(!listLive || !listMovie || !listSeries) return;
    listLive.innerHTML = ''; listMovie.innerHTML = ''; listSeries.innerHTML = '';

    if(todasCategorias.length === 0) {
        listLive.innerHTML = '<p class="text-gray-500 text-sm">Nenhuma categoria encontrada.</p>'; return;
    }

    todasCategorias.forEach(c => {
        const item = `<div class="bg-[#1e293b] border border-gray-600 p-3 rounded mb-2 cursor-move flex items-center shadow hover:border-blue-500" data-id="${c.id}"><i class="fas fa-grip-lines text-gray-500 mr-3"></i><span class="text-gray-200 font-medium truncate text-sm">${c.category_name}</span></div>`;
        if(c.category_type === 'live') listLive.innerHTML += item;
        else if(c.category_type === 'movie') listMovie.innerHTML += item;
        else if(c.category_type === 'series') listSeries.innerHTML += item;
    });

    new Sortable(listLive, { animation: 150, ghostClass: 'bg-blue-900' });
    new Sortable(listMovie, { animation: 150, ghostClass: 'bg-green-900' });
    new Sortable(listSeries, { animation: 150, ghostClass: 'bg-purple-900' });
}

async function salvarOrdemCategorias() {
    const btn = document.querySelector('button[onclick="salvarOrdemCategorias()"]');
    const txtOriginal = btn.innerHTML;
    btn.innerHTML = '<i class="fas fa-spinner fa-spin mr-2"></i>Salvando...'; btn.disabled = true;

    let ordem = [];
    document.querySelectorAll('#sortable-live > div').forEach((el, index) => ordem.push({ id: el.getAttribute('data-id'), order: index }));
    document.querySelectorAll('#sortable-movie > div').forEach((el, index) => ordem.push({ id: el.getAttribute('data-id'), order: index }));
    document.querySelectorAll('#sortable-series > div').forEach((el, index) => ordem.push({ id: el.getAttribute('data-id'), order: index }));

    if (ordem.length === 0) { alert("Não há categorias para salvar."); btn.innerHTML = txtOriginal; btn.disabled = false; return; }

    const fd = new FormData(); fd.append('ordem', JSON.stringify(ordem));

    try {
        const res = await fetch('api.php?action=salvar_ordem_categorias', { method: 'POST', body: fd }); 
        const text = await res.text();
        try {
            const json = JSON.parse(text);
            alert(json.msg || "Ordem salva com sucesso!");
        } catch(e) { alert("Erro de PHP: " + text.substring(0, 80)); }
        carregarCategorias(); 
    } catch(e) { alert("Erro de conexão ao salvar."); }
    
    btn.innerHTML = txtOriginal; btn.disabled = false;
}

// === IMPORTADOR M3U ===
async function lerCategoriasM3U() {
    const url = document.getElementById('m3u_url_input').value;
    if (!url || !url.includes('http')) return alert('Insira um link válido!');
    const btn = document.getElementById('btn-ler-m3u'); btn.innerHTML = '<i class="fas fa-spinner fa-spin mr-2"></i>Lendo...'; btn.disabled = true;
    const fd = new FormData(); fd.append('url_m3u', url);
    try {
        const res = await fetch('api.php?action=ler_m3u', { method: 'POST', body: fd }); const json = await res.json();
        if (json.success) {
            const list = document.getElementById('lista-categorias-m3u'); list.innerHTML = '';
            json.data.forEach(cat => { list.innerHTML += `<label class="flex items-center space-x-3 cursor-pointer p-2 hover:bg-gray-800 rounded border border-gray-800 mb-1"><input type="checkbox" name="import_cat[]" value="${cat}" class="form-checkbox h-5 w-5 text-green-600 bg-gray-900 border-gray-600 rounded"><span class="text-sm font-bold text-gray-200 truncate">${cat}</span></label>`; });
            document.getElementById('area-categorias-m3u').classList.remove('hidden'); document.getElementById('area-log').classList.add('hidden');
        } else { alert(json.msg); }
    } catch(e) { alert("Erro ao ler lista."); }
    btn.innerHTML = '<i class="fas fa-search mr-2"></i>Ler Lista'; btn.disabled = false;
}

function iniciarMonitoramentoLog() {
    document.getElementById('area-log').classList.remove('hidden');
    logIntervalo = setInterval(async () => {
        try {
            const res = await fetch('api.php?action=get_log'); const data = await res.json();
            if (data.total > 0) { document.getElementById('barra-progresso').style.width = `${Math.min(100, Math.round((data.atual / data.total) * 100))}%`; }
            document.getElementById('texto-log').innerText = data.msg;
            if (data.msg.includes("Concluído")) clearInterval(logIntervalo);
        } catch(e) {}
    }, 1500);
}

async function iniciarImportacaoM3U() {
    const url = document.getElementById('m3u_url_input').value;
    const marcados = Array.from(document.querySelectorAll('input[name="import_cat[]"]:checked')).map(cb => cb.value);
    if(marcados.length === 0) return alert("Selecione categoria!");
    if(!confirm("Iniciar importação? Pode demorar.")) return;
    const btn = document.getElementById('btn-iniciar-importacao'); btn.innerHTML = '<i class="fas fa-spinner fa-spin mr-2"></i>Importando...'; btn.disabled = true;
    document.getElementById('barra-progresso').style.width = `0%`; document.getElementById('texto-log').innerText = "Iniciando..."; iniciarMonitoramentoLog();
    const fd = new FormData(); fd.append('url_m3u', url); fd.append('categorias', JSON.stringify(marcados));
    try {
        const res = await fetch('api.php?action=importar_m3u', { method: 'POST', body: fd }); const json = await res.json();
        clearInterval(logIntervalo); document.getElementById('texto-log').innerText = json.msg; document.getElementById('barra-progresso').style.width = `100%`;
        alert(json.msg); if(json.success) { document.getElementById('m3u_url_input').value = ''; carregarCategorias(); }
    } catch(e) { clearInterval(logIntervalo); document.getElementById('texto-log').innerText = "Processando em segundo plano..."; }
    btn.innerHTML = '<i class="fas fa-download mr-2"></i> Importar com TMDB'; btn.disabled = false;
}

// === APAGAR CONTEÚDOS ===
function renderizarCategoriasApagar() {
    const list = document.getElementById('lista-categorias-apagar'); if (!list) return; list.innerHTML = '';
    if (todasCategorias.length === 0) { list.innerHTML = '<div class="text-gray-500 p-4 text-center">Banco vazio.</div>'; return; }
    let html = `<div class="flex space-x-2 mb-3 bg-[#1e293b] py-2 sticky top-0 z-10 border-b border-gray-700"><button type="button" onclick="marcarTodos('delete_cat[]', true)" class="bg-blue-600 text-white text-xs px-3 py-2 rounded">Selecionar Tudo</button><button type="button" onclick="marcarTodos('delete_cat[]', false)" class="bg-gray-600 text-white text-xs px-3 py-2 rounded">Desmarcar Tudo</button></div>`;
    let tipoAtual = '';
    todasCategorias.forEach(c => {
        const tipoReal = c.category_type || 'outros';
        if (tipoAtual !== tipoReal) {
            let icone = 'fa-folder'; let nomeTipo = 'Outros';
            if(tipoReal === 'live') { icone = 'fa-tv text-blue-400'; nomeTipo = 'Canais Ao Vivo'; } if(tipoReal === 'movie') { icone = 'fa-film text-green-400'; nomeTipo = 'Filmes'; } if(tipoReal === 'series') { icone = 'fa-video text-purple-400'; nomeTipo = 'Séries'; }
            html += `<div class="font-bold text-gray-300 text-sm uppercase mt-4 mb-2 pb-1 border-b border-gray-700"><i class="fas ${icone} mr-2"></i> ${nomeTipo}</div>`; tipoAtual = tipoReal;
        }
        html += `<label class="flex items-center space-x-3 cursor-pointer p-2 hover:bg-gray-800 rounded ml-2"><input type="checkbox" name="delete_cat[]" value="${c.id}" class="form-checkbox h-5 w-5 text-red-600 bg-gray-900 border-gray-600 rounded"><span class="text-sm font-medium text-gray-300 truncate">${c.category_name}</span></label>`;
    }); list.innerHTML = html;
}

async function apagarCategoriasSelecionadas() {
    const marcados = Array.from(document.querySelectorAll('input[name="delete_cat[]"]:checked')).map(cb => cb.value);
    if (marcados.length === 0) return alert("Selecione!");
    if (!confirm(`Vai excluir ${marcados.length} categoria(s) e TUDO que tem dentro. Continuar?`)) return;
    const btn = document.getElementById('btn-apagar-selecionados'); if(btn) { btn.innerHTML = '<i class="fas fa-spinner fa-spin mr-2"></i>Excluindo...'; btn.disabled = true; }
    const fd = new FormData(); fd.append('categorias', JSON.stringify(marcados)); fd.append('tipo_exclusao', 'selecionados');
    try { const res = await fetch('api.php?action=apagar_conteudos', { method: 'POST', body: fd }); const json = await res.json(); alert(json.msg); if (json.success) { await carregarCategorias(); renderizarCategoriasApagar(); } } catch(e) { alert("Erro ao excluir."); }
    if(btn) { btn.innerHTML = '<i class="fas fa-trash-alt mr-2"></i> Apagar Selecionados'; btn.disabled = false; }
}

async function apagarTodoConteudo() {
    if (!confirm("⚠️ ALERTA! ⚠️\n\nApagar TODOS canais, filmes, séries e categorias do banco?")) return;
    const btn = document.getElementById('btn-apagar-tudo'); if(btn) { btn.innerHTML = '<i class="fas fa-spinner fa-spin mr-2"></i>Limpando...'; btn.disabled = true; }
    const fd = new FormData(); fd.append('tipo_exclusao', 'tudo');
    try { const res = await fetch('api.php?action=apagar_conteudos', { method: 'POST', body: fd }); const json = await res.json(); alert(json.msg); if (json.success) { todasCategorias = []; renderizarCategoriasApagar(); } } catch(e) { alert("Erro fatal."); }
    if(btn) { btn.innerHTML = '<i class="fas fa-skull-crossbones mr-2"></i> APAGAR TUDO'; btn.disabled = false; }
}

// === CARREGAR CARDS ===
async function carregarDados() {
    const grid = document.getElementById('grid-cards'); const btnNovoMobile = document.getElementById('btnNovoMobile'); const btnNovoDesktop = document.getElementById('btnNovoDesktop');
    if(!grid) return; grid.innerHTML = `<div class="col-span-full text-center py-10 text-gray-500"><i class="fas fa-spinner fa-spin text-3xl mb-2 text-blue-500"></i><br>Carregando...</div>`;

    try {
        if (abaAtual === 'dashboard') {
            if(btnNovoMobile) btnNovoMobile.classList.add('hidden'); if(btnNovoDesktop) { btnNovoDesktop.classList.remove('md:flex'); btnNovoDesktop.classList.add('hidden'); }
            const res = await fetch(`api.php?action=dashboard_stats`); const json = await res.json();
            if (json.logout) { window.location.replace('login.php'); return; } if (!json.success) throw new Error(json.msg);
            const d = json.data;
            grid.innerHTML = `
                <div class="col-span-full mb-1 border-b border-gray-800 pb-2"><h2 class="text-lg font-bold text-gray-300"><i class="fas fa-users text-blue-500 mr-2"></i>Clientes Oficiais</h2></div>
                <div class="bg-[#1e293b] p-5 rounded-xl border border-gray-700 shadow-lg text-center relative"><span class="text-green-400 text-4xl font-black mb-1 block">${d.clientes.ativos}</span><span class="text-gray-400 text-xs uppercase font-bold tracking-wider">Ativos</span></div>
                <div class="bg-[#1e293b] p-5 rounded-xl border border-gray-700 shadow-lg text-center relative"><span class="text-yellow-500 text-4xl font-black mb-1 block">${d.clientes.vencidos}</span><span class="text-gray-400 text-xs uppercase font-bold tracking-wider">Vencidos</span></div>
                <div class="bg-[#1e293b] p-5 rounded-xl border border-gray-700 shadow-lg text-center relative"><span class="text-red-500 text-4xl font-black mb-1 block">${d.clientes.bloqueados}</span><span class="text-gray-400 text-xs uppercase font-bold tracking-wider">Bloqueados</span></div>
                <div class="col-span-full mt-4 mb-1 border-b border-gray-800 pb-2"><h2 class="text-lg font-bold text-gray-300"><i class="fas fa-clock text-yellow-500 mr-2"></i>Testes</h2></div>
                <div class="bg-[#1e293b] p-5 rounded-xl border border-gray-700 shadow-lg text-center"><span class="text-green-400 text-3xl font-bold mb-1 block">${d.testes.ativos}</span><span class="text-gray-400 text-[10px] uppercase font-bold tracking-wider">Ativos</span></div>
                <div class="bg-[#1e293b] p-5 rounded-xl border border-gray-700 shadow-lg text-center"><span class="text-yellow-500 text-3xl font-bold mb-1 block">${d.testes.vencidos}</span><span class="text-gray-400 text-[10px] uppercase font-bold tracking-wider">Vencidos</span></div>
                <div class="bg-[#1e293b] p-5 rounded-xl border border-gray-700 shadow-lg text-center"><span class="text-red-500 text-3xl font-bold mb-1 block">${d.testes.bloqueados}</span><span class="text-gray-400 text-[10px] uppercase font-bold tracking-wider">Bloqueados</span></div>
                <div class="col-span-full mt-4 mb-1 border-b border-gray-800 pb-2"><h2 class="text-lg font-bold text-gray-300"><i class="fas fa-server text-purple-500 mr-2"></i>Conteúdo do Servidor</h2></div>
                <div class="bg-[#1e293b] p-4 rounded-xl border border-gray-700 shadow-lg flex items-center justify-between"><div class="flex items-center"><div class="w-12 h-12 rounded-full bg-blue-900 bg-opacity-30 flex items-center justify-center mr-3"><i class="fas fa-tv text-2xl text-blue-400"></i></div><span class="text-gray-300 font-bold uppercase text-sm">Canais</span></div><span class="text-2xl font-black text-white">${d.conteudo.canais}</span></div>
                <div class="bg-[#1e293b] p-4 rounded-xl border border-gray-700 shadow-lg flex items-center justify-between"><div class="flex items-center"><div class="w-12 h-12 rounded-full bg-green-900 bg-opacity-30 flex items-center justify-center mr-3"><i class="fas fa-film text-2xl text-green-400"></i></div><span class="text-gray-300 font-bold uppercase text-sm">Filmes</span></div><span class="text-2xl font-black text-white">${d.conteudo.filmes}</span></div>
                <div class="bg-[#1e293b] p-4 rounded-xl border border-gray-700 shadow-lg flex items-center justify-between"><div class="flex items-center"><div class="w-12 h-12 rounded-full bg-purple-900 bg-opacity-30 flex items-center justify-center mr-3"><i class="fas fa-video text-2xl text-purple-400"></i></div><span class="text-gray-300 font-bold uppercase text-sm">Séries</span></div><span class="text-2xl font-black text-white">${d.conteudo.series}</span></div>
            `;
            return; 
        }

        if(btnNovoMobile) btnNovoMobile.classList.remove('hidden'); if(btnNovoDesktop) { btnNovoDesktop.classList.remove('hidden'); btnNovoDesktop.classList.add('md:flex'); }
        const res = await fetch(`api.php?action=get&type=${abaAtual}`); const json = await res.json();
        if (json.logout) { window.location.replace('login.php'); return; } if (!json.success) throw new Error(json.msg);
        
        dadosAtuais = json.data; serverUrl = json.server_url || ""; grid.innerHTML = '';
        if (dadosAtuais.length === 0) { grid.innerHTML = `<div class="col-span-full text-center py-10 text-gray-500">Vazio.</div>`; return; }

        dadosAtuais.forEach(item => {
            if (abaAtual === 'bouquets') {
                grid.innerHTML += `<div class="bg-[#1e293b] border border-gray-700 rounded-xl p-4 shadow-lg flex flex-col justify-between"><div><div class="flex justify-between items-start mb-2"><h3 class="text-lg font-bold text-gray-100 truncate"><i class="fas fa-layer-group text-purple-500 mr-2"></i>${item.bouquet_name}</h3><span class="text-xs text-gray-500 bg-gray-900 px-2 py-1 rounded border border-gray-700">ID: ${item.id}</span></div></div><div class="flex space-x-2 pt-4 mt-auto border-t border-gray-800"><button onclick="abrirModal(${item.id})" class="flex-1 bg-gray-600 text-white py-2 rounded-lg text-sm"><i class="fas fa-pen mr-2"></i>Editar</button><button onclick="excluirRegistro(${item.id})" class="flex-1 bg-red-600 text-white py-2 rounded-lg text-sm"><i class="fas fa-trash mr-2"></i>Excluir</button></div></div>`;
                return; 
            }
            const isAtivo = item.enabled == 1;
            const badgeStatus = isAtivo ? `<span class="bg-green-900 bg-opacity-50 text-green-400 text-xs px-2 py-1 rounded"><i class="fas fa-check"></i> ON</span>` : `<span class="bg-red-900 bg-opacity-50 text-red-400 text-xs px-2 py-1 rounded"><i class="fas fa-ban"></i> OFF</span>`;
            let infoExtra = ''; let btnRenovar = ''; let btnInfo = '';

            if (abaAtual === 'revendedores') {
                infoExtra = `<div class="flex justify-between text-sm mt-2 p-2 bg-[#0b1120] rounded border border-gray-700"><span class="text-gray-400"><i class="fas fa-coins text-yellow-500"></i> Créditos:</span><span class="text-white font-bold">${item.credits || 0}</span></div>`;
            } else {
                let dataExp = 'Ilimitado'; let corData = 'text-white';
                if (item.exp_date > 0) {
                    const dObj = new Date(item.exp_date * 1000); dataExp = `${String(dObj.getDate()).padStart(2, '0')}/${String(dObj.getMonth() + 1).padStart(2, '0')}/${dObj.getFullYear()}`;
                    if ((item.exp_date * 1000) < Date.now()) corData = 'text-red-500';
                }
                infoExtra = `<div class="flex justify-between text-sm mt-2 p-2 bg-[#0b1120] rounded border border-gray-700"><span class="text-gray-400"><i class="far fa-calendar-alt text-blue-400"></i> Vencimento:</span><span class="font-bold ${corData}">${dataExp}</span></div>`;
                btnRenovar = `<button onclick="abrirRenovar(${item.id})" class="flex-1 bg-green-600 text-white py-2 rounded-lg text-sm" title="Renovar"><i class="fas fa-sync-alt"></i></button>`;
                btnInfo = `<button onclick="abrirInfoModal(${item.id})" class="flex-1 bg-blue-600 text-white py-2 rounded-lg text-sm" title="Info"><i class="fas fa-eye"></i></button>`;
            }
            grid.innerHTML += `<div class="bg-[#1e293b] border border-gray-700 rounded-xl p-4 shadow-lg flex flex-col justify-between"><div><div class="flex justify-between items-start mb-2"><h3 class="text-lg font-bold text-gray-100 truncate"><i class="fas fa-user-circle text-gray-500 mr-2"></i>${item.username}</h3><div>${badgeStatus}</div></div><p class="text-xs text-gray-500 mb-2 font-mono">Senha: ${item.password}</p>${infoExtra}</div><div class="flex space-x-2 pt-4 mt-auto">${btnInfo}<button onclick="abrirModal(${item.id})" class="flex-1 bg-gray-600 text-white py-2 rounded-lg text-sm"><i class="fas fa-pen"></i></button>${btnRenovar}<button onclick="alternarStatus(${item.id}, ${item.enabled})" class="flex-1 bg-yellow-600 text-white py-2 rounded-lg text-sm"><i class="fas ${isAtivo ? 'fa-lock' : 'fa-lock-open'}"></i></button><button onclick="excluirRegistro(${item.id})" class="flex-1 bg-red-600 text-white py-2 rounded-lg text-sm"><i class="fas fa-trash"></i></button></div></div>`;
        });
    } catch (e) { grid.innerHTML = `<div class="col-span-full text-center text-red-500 bg-red-900 bg-opacity-20 p-4 rounded-lg">Erro na comunicação.</div>`; }
}

// === MODAIS ===
function renderizarBouquets(userBouquets = []) {
    const list = document.getElementById('bouquetsList'); if(!list) return; list.innerHTML = '';
    if(todosBouquets.length === 0) { list.innerHTML = '<span class="text-xs text-gray-500">Vazio.</span>'; return; }
    let html = `<div class="flex space-x-2 mb-3 sticky top-0 bg-[#0f172a] py-1 z-10 border-b border-gray-700 pb-2"><button type="button" onclick="marcarTodos('bouquets[]', true)" class="text-[11px] font-bold bg-blue-600 text-white px-3 py-1.5 rounded">Selecionar Todos</button><button type="button" onclick="marcarTodos('bouquets[]', false)" class="text-[11px] font-bold bg-gray-600 text-white px-3 py-1.5 rounded">Desmarcar Todos</button></div>`;
    todosBouquets.forEach(b => {
        const isChecked = userBouquets.some(id => Number(id) === Number(b.id)) ? 'checked' : '';
        html += `<label class="flex items-center space-x-3 cursor-pointer p-1.5 hover:bg-gray-800 rounded"><input type="checkbox" name="bouquets[]" value="${b.id}" ${isChecked} class="form-checkbox h-4 w-4 text-blue-600 bg-gray-900 border-gray-600 rounded"><span class="text-sm text-gray-300 truncate">${b.bouquet_name}</span></label>`;
    }); list.innerHTML = html;
}

function renderizarCategorias(marcadas = []) {
    const list = document.getElementById('categoriasList'); if(!list) return; list.innerHTML = '';
    if(todasCategorias.length === 0) { list.innerHTML = '<span class="text-xs text-gray-500">Vazio.</span>'; return; }
    let html = `<div class="flex space-x-2 mb-2 sticky top-0 bg-[#0f172a] py-1 z-10 border-b border-gray-700 pb-2"><button type="button" onclick="marcarTodos('categorias[]', true)" class="text-[11px] font-bold bg-blue-600 text-white px-3 py-1.5 rounded">Selecionar Todas</button><button type="button" onclick="marcarTodos('categorias[]', false)" class="text-[11px] font-bold bg-gray-600 text-white px-3 py-1.5 rounded">Desmarcar Todas</button></div>`;
    let tipoAtual = '';
    todasCategorias.forEach(c => {
        const tipoReal = c.category_type || 'outros';
        if (tipoAtual !== tipoReal) { html += `<div class="font-bold text-gray-400 text-xs uppercase mt-3 mb-1 pb-1 border-b border-gray-700">${tipoReal}</div>`; tipoAtual = tipoReal; }
        const isChecked = marcadas.some(id => Number(id) === Number(c.id)) ? 'checked' : '';
        html += `<label class="flex items-center space-x-3 cursor-pointer p-1 hover:bg-gray-800 rounded ml-2"><input type="checkbox" name="categorias[]" value="${c.id}" ${isChecked} class="form-checkbox h-4 w-4 text-blue-600 bg-gray-900 border-gray-600 rounded"><span class="text-sm text-gray-300 truncate">${c.category_name}</span></label>`;
    }); list.innerHTML = html;
}

function abrirModal(id = null) {
    const modal = document.getElementById('formModal'); document.getElementById('mainForm').reset();
    ['camposRevenda','camposCliente','camposBouquet'].forEach(c => { const el = document.getElementById(c); if(el) el.classList.add('hidden'); });
    const divUserPass = document.getElementById('divUserPass'); if(divUserPass) divUserPass.classList.remove('hidden'); 

    if (abaAtual === 'revendedores') { document.getElementById('camposRevenda').classList.remove('hidden'); } 
    else if (abaAtual === 'bouquets') { document.getElementById('camposBouquet').classList.remove('hidden'); if(divUserPass) divUserPass.classList.add('hidden'); } 
    else { document.getElementById('camposCliente').classList.remove('hidden'); }

    if (id) {
        const dados = dadosAtuais.find(d => d.id == id); if (!dados) return;
        document.getElementById('modalTitle').innerText = "Editar Registro"; document.getElementById('formId').value = dados.id;
        
        if (abaAtual === 'bouquets') { 
            document.getElementById('formBouquetName').value = dados.bouquet_name; 
            renderizarCategorias(dados.category_ids || []);
        } else {
            document.getElementById('formUser').value = dados.username; document.getElementById('formPass').value = dados.password;
            if(abaAtual === 'revendedores') { document.getElementById('formEmail').value = dados.email || ''; document.getElementById('formCredits').value = dados.credits || 0; } 
            else {
                if (dados.exp_date > 0) { const d = new Date(dados.exp_date * 1000); document.getElementById('formVencimento').value = `${d.getFullYear()}-${String(d.getMonth() + 1).padStart(2, '0')}-${String(d.getDate()).padStart(2, '0')}`; } else { document.getElementById('formVencimento').value = ""; }
                let arrayBouquets = []; try { if (dados.bouquet && typeof dados.bouquet === 'string') { arrayBouquets = JSON.parse(dados.bouquet); } else if (Array.isArray(dados.bouquet)) { arrayBouquets = dados.bouquet; } } catch(e) {}
                renderizarBouquets(arrayBouquets);
            }
        }
    } else {
        document.getElementById('modalTitle').innerText = "Novo Registro"; document.getElementById('formId').value = '';
        const fV = document.getElementById('formVencimento'); if(fV) fV.value = '';
        if (abaAtual === 'bouquets') { renderizarCategorias([]); } else { renderizarBouquets([]); }
    }
    modal.classList.remove('hidden');
}

function fecharModal() { document.getElementById('formModal').classList.add('hidden'); }
async function salvarDados() {
    const fd = new FormData(document.getElementById('mainForm'));
    try {
        const res = await fetch(`api.php?action=save&type=${abaAtual}`, { method: 'POST', body: fd }); const json = await res.json();
        if (json.success) { fecharModal(); carregarDados(); if(abaAtual === 'bouquets') carregarBouquets(); } else { alert(json.msg); }
    } catch(e) { alert("Erro de rede ao salvar."); }
}

function abrirRenovar(id) { document.getElementById('renewId').value = id; document.getElementById('renewModal').classList.remove('hidden'); }
async function confirmarRenovacao() {
    const fd = new FormData(); fd.append('id', document.getElementById('renewId').value); fd.append('meses', document.getElementById('renewMeses').value);
    await fetch(`api.php?action=renew`, { method: 'POST', body: fd }); document.getElementById('renewModal').classList.add('hidden'); carregarDados();
}

function abrirInfoModal(id) {
    const item = dadosAtuais.find(d => d.id == id); if (!item) return;
    let dataExp = 'Ilimitado'; if (item.exp_date > 0) { const dObj = new Date(item.exp_date * 1000); dataExp = `${String(dObj.getDate()).padStart(2, '0')}/${String(dObj.getMonth() + 1).padStart(2, '0')}/${dObj.getFullYear()}`; }
    const m3uLink = `${serverUrl}/get.php?username=${item.username}&password=${item.password}&type=m3u_plus&output=mpegts`;
    const texto = `👋 *Olá!*\n\n🌐 *Servidor:* ${serverUrl}\n👤 *Usuário:* ${item.username}\n🔑 *Senha:* ${item.password}\n📅 *Vencimento:* ${dataExp}\n\n📺 *Lista M3U:*\n${m3uLink}\n\n🍿 Bom entretenimento!`;
    document.getElementById('textoInfo').value = texto; document.getElementById('infoModal').classList.remove('hidden');
}
function fecharInfoModal() { document.getElementById('infoModal').classList.add('hidden'); }
function copiarInfo() { const t = document.getElementById('textoInfo'); t.select(); t.setSelectionRange(0, 99999); navigator.clipboard.writeText(t.value).then(() => { alert("Copiado!"); }); }
function enviarWhatsApp() { const t = document.getElementById('textoInfo').value; window.open(`https://api.whatsapp.com/send?text=${encodeURIComponent(t)}`, '_blank'); }

async function alternarStatus(id, statusAtual) { if(!confirm("Bloquear/desbloquear acesso?")) return; const fd = new FormData(); fd.append('id', id); fd.append('status', statusAtual); await fetch(`api.php?action=toggle&type=${abaAtual}`, { method: 'POST', body: fd }); carregarDados(); }
async function excluirRegistro(id) { if(!confirm("TEM CERTEZA? Exclusão permanente!")) return; const fd = new FormData(); fd.append('id', id); await fetch(`api.php?action=delete&type=${abaAtual}`, { method: 'POST', body: fd }); carregarDados(); }
