<?php session_start(); if (!isset($_SESSION['logado']) || $_SESSION['logado'] !== true) { header('Location: login.php'); exit; } ?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Painel Gestor</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <script src="https://cdn.jsdelivr.net/npm/sortablejs@latest/Sortable.min.js"></script>
    <style>
        :root { color-scheme: dark; } html, body { background-color: #0f172a !important; color: #f8fafc; margin: 0; padding: 0; height: 100vh; overflow: hidden; }
        input:-webkit-autofill { -webkit-box-shadow: 0 0 0 30px #1e293b inset !important; -webkit-text-fill-color: white !important; }
        ::-webkit-scrollbar { width: 6px; } ::-webkit-scrollbar-track { background: #0f172a; } ::-webkit-scrollbar-thumb { background: #334155; border-radius: 4px; }
    </style>
</head>
<body class="flex antialiased">

    <aside id="sidebar" class="w-64 bg-[#0b1120] border-r border-gray-800 flex-shrink-0 absolute inset-y-0 left-0 transform -translate-x-full md:relative md:translate-x-0 transition-transform duration-300 z-40 shadow-2xl flex flex-col h-full">
        <div class="p-5 border-b border-gray-800 flex justify-between items-center bg-[#070b14]">
            <span class="text-xl font-bold text-blue-500 uppercase tracking-wider"><i class="fas fa-bolt text-yellow-500 mr-2"></i>Painel</span>
            <button id="closeSidebar" class="md:hidden text-gray-400 hover:text-white text-2xl"><i class="fas fa-times"></i></button>
        </div>
        
        <nav class="p-4 space-y-2 flex-1 overflow-y-auto">
            <p class="text-xs font-bold text-gray-500 uppercase mb-3 ml-2">Geral</p>
            <button onclick="mudarAba('dashboard')" id="btn-dashboard" class="nav-btn w-full text-left px-4 py-3 bg-blue-600 rounded-lg text-white font-medium shadow-md transition-colors flex items-center mb-4"><i class="fas fa-chart-pie w-6 text-center mr-2"></i> Dashboard</button>
            <p class="text-xs font-bold text-gray-500 uppercase mb-3 ml-2 mt-4">Gestão</p>
            <button onclick="mudarAba('clientes')" id="btn-clientes" class="nav-btn w-full text-left px-4 py-3 text-gray-400 hover:bg-gray-800 hover:text-white rounded-lg transition-colors flex items-center"><i class="fas fa-user-check w-6 text-center mr-2"></i> Clientes Oficiais</button>
            <button onclick="mudarAba('testes')" id="btn-testes" class="nav-btn w-full text-left px-4 py-3 text-gray-400 hover:bg-gray-800 hover:text-white rounded-lg transition-colors flex items-center"><i class="fas fa-clock w-6 text-center mr-2"></i> Testes</button>
            <button onclick="mudarAba('revendedores')" id="btn-revendedores" class="nav-btn w-full text-left px-4 py-3 text-gray-400 hover:bg-gray-800 hover:text-white rounded-lg transition-colors flex items-center"><i class="fas fa-user-tie w-6 text-center mr-2"></i> Revendedores</button>

            <?php if (isset($_SESSION['is_admin']) && $_SESSION['is_admin']): ?>
            <button onclick="mudarAba('bouquets')" id="btn-bouquets" class="nav-btn w-full text-left px-4 py-3 text-gray-400 hover:bg-gray-800 hover:text-white rounded-lg transition-colors flex items-center"><i class="fas fa-layer-group w-6 text-center mr-2"></i> Bouquets</button>
            <p class="text-xs font-bold text-gray-500 uppercase mb-3 ml-2 mt-6">Sistema</p>
            <button onclick="mudarAba('importador')" id="btn-importador" class="nav-btn w-full text-left px-4 py-3 text-gray-400 hover:bg-gray-800 hover:text-white rounded-lg transition-colors flex items-center"><i class="fas fa-cloud-download-alt w-6 text-center mr-2 text-green-400"></i> Importar M3U</button>
            
            <button onclick="mudarAba('organizar')" id="btn-organizar" class="nav-btn w-full text-left px-4 py-3 text-gray-400 hover:bg-gray-800 hover:text-white rounded-lg transition-colors flex items-center mt-2"><i class="fas fa-sort-numeric-down w-6 text-center mr-2 text-blue-300"></i> Organizar Categorias</button>
            
            <button onclick="mudarAba('apagar')" id="btn-apagar" class="nav-btn w-full text-left px-4 py-3 text-gray-400 hover:bg-gray-800 hover:text-red-400 rounded-lg transition-colors flex items-center mt-2"><i class="fas fa-trash-alt w-6 text-center mr-2 text-red-500"></i> Apagar Conteúdos</button>
            <?php endif; ?>
        </nav>

        <div class="p-4 border-t border-gray-800 bg-[#070b14]"><a href="logout.php" class="flex items-center justify-center w-full px-4 py-3 bg-red-900 bg-opacity-20 text-red-500 hover:bg-red-600 hover:text-white rounded-lg font-bold border border-red-900"><i class="fas fa-sign-out-alt mr-2"></i> Sair</a></div>
    </aside>

    <div id="sidebarOverlay" class="fixed inset-0 bg-black bg-opacity-80 z-30 hidden md:hidden"></div>

    <main class="flex-1 flex flex-col h-full relative z-10 w-full bg-[#0f172a]">
        <header class="bg-[#0b1120] p-4 border-b border-gray-800 flex items-center justify-between shadow-md h-16">
            <div class="flex items-center"><button id="openSidebar" class="text-gray-300 hover:text-white md:hidden mr-4"><i class="fas fa-bars text-2xl"></i></button><h1 id="tituloPagina" class="text-lg font-semibold text-gray-100">Dashboard</h1><button onclick="carregarDados()" id="btn-recarregar" class="ml-4 text-blue-500 hover:text-blue-300 p-2 bg-blue-900 bg-opacity-20 rounded-full"><i class="fas fa-sync-alt"></i></button></div>
            <div class="hidden md:flex items-center space-x-4"><div class="text-right mr-3 border-r border-gray-700 pr-4"><p class="text-sm font-bold text-gray-200"><?= htmlspecialchars($_SESSION['username'] ?? '') ?></p><p class="text-xs text-blue-400"><?= (isset($_SESSION['is_admin']) && $_SESSION['is_admin']) ? 'Administrador' : 'Revendedor' ?></p></div><button id="btnNovoDesktop" onclick="abrirModal()" class="bg-blue-600 hover:bg-blue-500 text-white px-4 py-2 rounded-lg text-sm font-medium"><i class="fas fa-plus mr-2"></i> Novo</button></div>
        </header>

        <div class="flex-1 overflow-y-auto p-4 md:p-6 relative">
            <div id="grid-cards" class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-4 pb-20"></div>
            
            <div id="tela-importador" class="hidden max-w-3xl mx-auto w-full pb-20">
                <div class="bg-[#1e293b] border border-gray-700 rounded-xl p-5 shadow-2xl"><h2 class="text-xl font-bold text-green-400 mb-4"><i class="fas fa-cloud-download-alt mr-2"></i>Importar Links M3U</h2><div class="flex flex-col md:flex-row gap-3 mb-6"><input type="url" id="m3u_url_input" placeholder="http://link.com/get.php..." class="flex-1 bg-[#0f172a] border border-gray-600 rounded-lg p-3 text-white focus:border-green-500"><button onclick="lerCategoriasM3U()" id="btn-ler-m3u" class="bg-blue-600 hover:bg-blue-500 text-white px-6 py-3 rounded-lg font-bold"><i class="fas fa-search mr-2"></i>Ler</button></div><div id="area-categorias-m3u" class="hidden border-t border-gray-700 pt-4 mt-2"><div class="flex justify-between items-center mb-3"><h3 class="font-bold text-gray-200">Selecione para Importar:</h3><div><button onclick="marcarTodos('import_cat[]', true)" class="text-[11px] bg-gray-700 px-2 py-1 rounded text-white mr-1">Todas</button><button onclick="marcarTodos('import_cat[]', false)" class="text-[11px] bg-gray-800 px-2 py-1 rounded text-white border border-gray-600">Nenhuma</button></div></div><div id="lista-categorias-m3u" class="bg-[#0f172a] border border-gray-700 rounded-lg p-3 h-64 overflow-y-auto mb-4"></div><button onclick="iniciarImportacaoM3U()" id="btn-iniciar-importacao" class="w-full bg-green-600 hover:bg-green-500 text-white py-4 rounded-lg font-bold text-lg"><i class="fas fa-download mr-2"></i> Importar com TMDB</button><div id="area-log" class="hidden mt-6 bg-[#0b1120] border border-gray-700 rounded-lg p-4"><h4 class="text-blue-400 font-bold mb-2"><i class="fas fa-terminal mr-2"></i>Status</h4><div class="w-full bg-gray-800 rounded-full h-2.5 mb-2"><div id="barra-progresso" class="bg-blue-600 h-2.5 rounded-full" style="width: 0%"></div></div><p id="texto-log" class="text-xs text-gray-400 font-mono mt-2">Preparando...</p></div></div></div>
            </div>

            <div id="tela-organizar" class="hidden max-w-6xl mx-auto w-full pb-20">
                <div class="bg-[#1e293b] border border-gray-700 rounded-xl p-5 shadow-2xl">
                    <div class="flex flex-col md:flex-row justify-between items-start md:items-center mb-6 gap-4">
                        <div><h2 class="text-xl font-bold text-blue-400"><i class="fas fa-sort-amount-down mr-2"></i>Organizar Categorias</h2><p class="text-sm text-gray-400">Segure e arraste as categorias para ordenar.</p></div>
                        <button onclick="salvarOrdemCategorias()" class="w-full md:w-auto bg-green-600 hover:bg-green-500 text-white px-6 py-3 rounded-lg font-bold shadow-lg"><i class="fas fa-save mr-2"></i> Salvar Ordem</button>
                    </div>
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                        <div class="bg-[#0f172a] border border-gray-700 rounded-lg p-3"><h3 class="font-bold text-gray-200 mb-3 border-b border-gray-700 pb-2"><i class="fas fa-tv text-blue-400 mr-2"></i>Canais</h3><div id="sortable-live" class="space-y-2 min-h-[100px]"></div></div>
                        <div class="bg-[#0f172a] border border-gray-700 rounded-lg p-3"><h3 class="font-bold text-gray-200 mb-3 border-b border-gray-700 pb-2"><i class="fas fa-film text-green-400 mr-2"></i>Filmes</h3><div id="sortable-movie" class="space-y-2 min-h-[100px]"></div></div>
                        <div class="bg-[#0f172a] border border-gray-700 rounded-lg p-3"><h3 class="font-bold text-gray-200 mb-3 border-b border-gray-700 pb-2"><i class="fas fa-video text-purple-400 mr-2"></i>Séries</h3><div id="sortable-series" class="space-y-2 min-h-[100px]"></div></div>
                    </div>
                </div>
            </div>

            <div id="tela-apagar" class="hidden max-w-3xl mx-auto w-full pb-20">
                <div class="bg-[#1e293b] border border-red-900 rounded-xl p-5 shadow-2xl">
                    <h2 class="text-xl font-bold text-red-500 mb-4"><i class="fas fa-trash-alt mr-2"></i>Apagar Conteúdos do Banco</h2><p class="text-sm text-gray-400 mb-6">Selecione para excluir categoria, canais, filmes, séries e episódios associados.</p>
                    <div id="lista-categorias-apagar" class="bg-[#0f172a] border border-gray-700 rounded-lg p-3 h-[400px] overflow-y-auto mb-4"></div>
                    <button onclick="apagarCategoriasSelecionadas()" id="btn-apagar-selecionados" class="w-full bg-red-600 hover:bg-red-500 text-white py-4 rounded-lg font-bold text-lg mb-8"><i class="fas fa-trash-alt mr-2"></i> Apagar Selecionados</button>
                    <hr class="border-gray-700 mb-8">
                    <div class="bg-red-900 bg-opacity-20 border border-red-800 rounded-lg p-5 text-center"><h3 class="text-red-400 font-bold text-lg mb-2">Zerar Todo o Conteúdo (Wipe)</h3><button onclick="apagarTodoConteudo()" id="btn-apagar-tudo" class="w-full bg-red-800 hover:bg-red-700 text-white py-3 rounded-lg font-bold"><i class="fas fa-skull-crossbones mr-2"></i> APAGAR TUDO</button></div>
                </div>
            </div>
        </div>
        
        <button id="btnNovoMobile" onclick="abrirModal()" class="hidden fixed bottom-6 right-6 bg-blue-600 text-white w-14 h-14 rounded-full flex items-center justify-center text-2xl z-20 md:hidden"><i class="fas fa-plus"></i></button>
    </main>

    <div id="formModal" class="fixed inset-0 z-50 hidden bg-black bg-opacity-80 flex items-center justify-center p-4">
        <div class="bg-[#1e293b] border border-gray-700 rounded-2xl w-full max-w-md shadow-2xl flex flex-col max-h-[90vh]">
            <div class="flex justify-between items-center p-5 border-b border-gray-700 bg-[#0f172a] rounded-t-2xl"><h2 id="modalTitle" class="text-xl font-bold text-blue-400">Adicionar</h2><button onclick="fecharModal()" class="text-gray-400 hover:text-white text-2xl"><i class="fas fa-times"></i></button></div>
            <div class="p-5 overflow-y-auto">
                <form id="mainForm" class="space-y-4">
                    <input type="hidden" id="formId" name="id">
                    <div id="divUserPass" class="grid grid-cols-2 gap-4"><div><label class="block text-sm text-gray-400 mb-1">Usuário</label><input type="text" id="formUser" name="username" class="w-full bg-[#0f172a] border border-gray-600 rounded-lg p-3 text-white"></div><div><label class="block text-sm text-gray-400 mb-1">Senha</label><input type="text" id="formPass" name="password" class="w-full bg-[#0f172a] border border-gray-600 rounded-lg p-3 text-white"></div></div>
                    <div id="camposBouquet" class="hidden space-y-4"><div><label class="block text-sm text-gray-400 mb-1">Nome do Pacote</label><input type="text" id="formBouquetName" name="bouquet_name" class="w-full bg-[#0f172a] border border-gray-600 rounded-lg p-3 text-white"></div><div><label class="block text-sm text-gray-400 mb-2">Incluir Categorias</label><div id="categoriasList" class="bg-[#0f172a] border border-gray-600 rounded-lg p-3 max-h-48 overflow-y-auto space-y-2"></div></div></div>
                    <div id="camposRevenda" class="hidden space-y-4"><div><label class="block text-sm text-gray-400 mb-1">E-mail</label><input type="email" id="formEmail" name="email" class="w-full bg-[#0f172a] border border-gray-600 rounded-lg p-3 text-white"></div><div><label class="block text-sm text-gray-400 mb-1">Créditos</label><input type="number" id="formCredits" name="credits" class="w-full bg-[#0f172a] border border-gray-600 rounded-lg p-3 text-white"></div></div>
                    <div id="camposCliente" class="space-y-4"><div><label class="block text-sm text-gray-400 mb-1">Data de Vencimento</label><input type="date" id="formVencimento" name="vencimento" class="w-full bg-[#0f172a] border border-gray-600 rounded-lg p-3 text-white [color-scheme:dark]"></div><div><label class="block text-sm text-gray-400 mb-2">Pacotes Permitidos</label><div id="bouquetsList" class="bg-[#0f172a] border border-gray-600 rounded-lg p-3 max-h-32 overflow-y-auto space-y-2"></div></div></div>
                </form>
            </div>
            <div class="p-5 border-t border-gray-700 flex space-x-3 bg-[#0f172a] rounded-b-2xl"><button onclick="fecharModal()" class="flex-1 bg-gray-700 hover:bg-gray-600 text-white py-3 rounded-lg font-medium">Cancelar</button><button onclick="salvarDados()" class="flex-1 bg-blue-600 hover:bg-blue-500 text-white py-3 rounded-lg font-medium">Salvar</button></div>
        </div>
    </div>

    <div id="infoModal" class="fixed inset-0 z-50 hidden bg-black bg-opacity-80 flex items-center justify-center p-4"><div class="bg-[#1e293b] border border-gray-700 rounded-2xl w-full max-w-md shadow-2xl"><div class="flex justify-between items-center p-5 border-b border-gray-700 bg-[#0f172a] rounded-t-2xl"><h2 class="text-lg font-bold text-white"><i class="fas fa-info-circle text-blue-400 mr-2"></i>Acesso</h2><button onclick="fecharInfoModal()" class="text-gray-400 hover:text-white text-2xl"><i class="fas fa-times"></i></button></div><div class="p-5"><textarea id="textoInfo" class="w-full bg-[#0f172a] border border-gray-600 text-sm text-gray-300 rounded-lg p-3 h-48 focus:outline-none" readonly></textarea><div class="flex space-x-3 mt-4"><button onclick="copiarInfo()" class="flex-1 bg-gray-700 hover:bg-gray-600 text-white py-3 rounded-lg"><i class="fas fa-copy mr-2"></i> Copiar</button><button onclick="enviarWhatsApp()" class="flex-1 bg-green-600 hover:bg-green-500 text-white py-3 rounded-lg font-bold"><i class="fab fa-whatsapp text-xl mr-2"></i> WhatsApp</button></div></div></div></div>
    <div id="renewModal" class="fixed inset-0 z-50 hidden bg-black bg-opacity-80 flex items-center justify-center p-4"><div class="bg-[#1e293b] border border-gray-700 rounded-2xl w-full max-w-sm"><div class="p-5 border-b border-gray-700 bg-[#0f172a] rounded-t-2xl"><h2 class="text-lg font-bold text-white">Renovar</h2></div><div class="p-5"><input type="hidden" id="renewId"><label class="block text-sm text-gray-400 mb-1">Meses:</label><input type="number" id="renewMeses" value="1" min="1" class="w-full bg-[#0f172a] border border-gray-600 rounded-lg p-3 text-white mb-4"><div class="flex space-x-3"><button onclick="document.getElementById('renewModal').classList.add('hidden')" class="flex-1 bg-gray-700 text-white py-3 rounded-lg font-medium">Cancelar</button><button onclick="confirmarRenovacao()" class="flex-1 bg-green-600 text-white py-3 rounded-lg font-bold">Renovar</button></div></div></div></div>

    <script src="app.js"></script>
</body>
</html>
