// app.js
let abaAtual = 'dashboard'; let dadosAtuais = []; let todosBouquets = []; let todasCategorias = []; let serverUrl = ""; let logIntervalo = null; let currentSeriesId = 0; let currentSeriesName = '';
let cacheDados = {}; 

document.addEventListener('DOMContentLoaded', () => {
    document.getElementById('openSidebar').addEventListener('click', toggleMenu);
    document.getElementById('closeSidebar').addEventListener('click', toggleMenu);
    document.getElementById('sidebarOverlay').addEventListener('click', toggleMenu);
    document.getElementById('btn-recarregar').onclick = () => carregarDados(true);
    carregarBouquets(); carregarCategorias(); carregarDados();
});

const toggleMenu = () => { document.getElementById('sidebar').classList.toggle('-translate-x-full'); document.getElementById('sidebarOverlay').classList.toggle('hidden'); };
window.marcarTodos = (name, state) => document.querySelectorAll(`input[name="${name}"]`).forEach(cb => cb.checked = state);
function fecharModal(id) { document.getElementById(id).classList.add('hidden'); }

async function carregarBouquets() { try { const res = await fetch('api.php?action=get_bouquets'); const j = await res.json(); if(j.success) todosBouquets = j.data; } catch(e){} }
async function carregarCategorias() { try { const res = await fetch('api.php?action=get_categories'); const j = await res.json(); if(j.success) todasCategorias = j.data; } catch(e){} }

function mudarAba(nova) {
    abaAtual = nova; if(nova !== 'episodios') currentSeriesId = 0;
    document.querySelectorAll('.nav-btn').forEach(b => { b.classList.remove('bg-blue-600', 'text-white', 'shadow-md'); b.classList.add('text-gray-400', 'hover:bg-gray-800'); });
    const bAtivo = document.getElementById(`btn-${nova === 'episodios' ? 'series' : nova}`); if(bAtivo) { bAtivo.classList.remove('text-gray-400', 'hover:bg-gray-800'); bAtivo.classList.add('bg-blue-600', 'text-white', 'shadow-md'); }
    
    const t = { dashboard:'Dashboard', clientes:'Clientes', testes:'Testes', revendedores:'Revendedores', bouquets:'Bouquets', importador:'Importar', organizar:'Organizar', apagar:'Limpeza', canais:'Canais', filmes:'Filmes', series:'Séries', episodios:'Episódios', seguranca:'Firewall WAF' };
    document.getElementById('tituloPagina').innerText = t[nova] || 'Painel';
    if(window.innerWidth < 768) toggleMenu();
    
    ['grid-cards', 'tela-importador', 'tela-apagar', 'tela-organizar', 'topo-series'].forEach(id => { const e = document.getElementById(id); if(e) e.classList.add('hidden'); });
    ['btnNovoMobile', 'btnNovoDesktop', 'btn-recarregar', 'areaPesquisa', 'areaPesquisaMobile'].forEach(id => { const e = document.getElementById(id); if(e) e.classList.add('hidden'); });
    document.getElementById('inputPesquisa').value = ''; document.getElementById('inputPesquisaMobile').value = '';

    if (nova === 'importador') document.getElementById('tela-importador').classList.remove('hidden');
    else if (nova === 'apagar') { document.getElementById('tela-apagar').classList.remove('hidden'); renderizarCategoriasApagar(); }
    else if (nova === 'organizar') { document.getElementById('tela-organizar').classList.remove('hidden'); renderizarOrganizacaoCategorias(); }
    else { 
        document.getElementById('grid-cards').classList.remove('hidden'); document.getElementById('btn-recarregar').classList.remove('hidden'); 
        if (nova !== 'dashboard' && nova !== 'seguranca') { document.getElementById('btnNovoMobile').classList.remove('hidden'); document.getElementById('btnNovoDesktop').classList.remove('hidden'); }
        if (['canais', 'filmes', 'series', 'episodios', 'seguranca'].includes(nova)) { document.getElementById('areaPesquisa').classList.remove('hidden'); document.getElementById('areaPesquisaMobile').classList.remove('hidden'); }
        if (nova === 'episodios') { document.getElementById('topo-series').classList.remove('hidden'); document.getElementById('nome-serie-atual').innerText = currentSeriesName; }
        carregarDados(false); 
    }
}

function pesquisarGrid(isMobile = false) {
    const termo = document.getElementById(isMobile ? 'inputPesquisaMobile' : 'inputPesquisa').value.toLowerCase();
    document.querySelectorAll('#grid-cards > div').forEach(card => {
        const titulo = card.querySelector('h3').innerText.toLowerCase();
        card.style.display = titulo.includes(termo) ? 'flex' : 'none';
    });
}

async function carregarDados(forcarRecarregamento = false) {
    const grid = document.getElementById('grid-cards'); if(!grid) return;
    let chaveCache = abaAtual === 'episodios' ? `episodios_${currentSeriesId}` : abaAtual;
    if (!forcarRecarregamento && cacheDados[chaveCache]) { renderizarCardsHtml(cacheDados[chaveCache]); return; }
    grid.innerHTML = `<div class="col-span-full text-center py-10 text-gray-500"><i class="fas fa-spinner fa-spin text-4xl text-blue-500 mb-3"></i><br>Carregando...</div>`;
    try {
        if (abaAtual === 'dashboard') {
            const res = await fetch(`api.php?action=dashboard_stats`); const j = await res.json();
            if (j.logout) return window.location.replace('login.php');
            cacheDados[chaveCache] = {isDash: true, d: j.data}; renderizarCardsHtml(cacheDados[chaveCache]); return;
        }
        let urlFetch = `api.php?action=get&type=${abaAtual}`; if(abaAtual === 'episodios') urlFetch += `&series_id=${currentSeriesId}`;
        const res = await fetch(urlFetch); const j = await res.json();
        if (j.logout) return window.location.replace('login.php');
        serverUrl = j.server_url; cacheDados[chaveCache] = {isDash: false, d: j.data}; renderizarCardsHtml(cacheDados[chaveCache]);
    } catch (e) { grid.innerHTML = `<div class="col-span-full text-center text-red-500">Erro de rede.</div>`; }
}

function renderizarCardsHtml(dadosSalvos) {
    const grid = document.getElementById('grid-cards'); let html = [];
    if (dadosSalvos.isDash) {
        const d = dadosSalvos.d;
        grid.innerHTML = `<div class="col-span-full mb-1 border-b border-gray-800 pb-2"><h2 class="text-lg font-bold text-gray-300">Clientes</h2></div><div class="bg-[#1e293b] p-5 rounded-xl border border-gray-700 text-center"><span class="text-green-400 text-4xl font-black mb-1 block">${d.clientes.ativos}</span><span class="text-gray-400 text-xs font-bold">Ativos</span></div><div class="bg-[#1e293b] p-5 rounded-xl border border-gray-700 text-center"><span class="text-yellow-500 text-4xl font-black mb-1 block">${d.clientes.vencidos}</span><span class="text-gray-400 text-xs font-bold">Vencidos</span></div><div class="bg-[#1e293b] p-5 rounded-xl border border-gray-700 text-center"><span class="text-red-500 text-4xl font-black mb-1 block">${d.clientes.bloqueados}</span><span class="text-gray-400 text-xs font-bold">Bloqueados</span></div><div class="col-span-full mt-4 mb-1 border-b border-gray-800 pb-2"><h2 class="text-lg font-bold text-gray-300">Conteúdos</h2></div><div class="bg-[#1e293b] p-4 rounded-xl border border-gray-700 flex justify-between items-center"><span class="text-gray-300 font-bold text-sm">Canais</span><span class="text-2xl font-black text-white">${d.conteudo.canais}</span></div><div class="bg-[#1e293b] p-4 rounded-xl border border-gray-700 flex justify-between items-center"><span class="text-gray-300 font-bold text-sm">Filmes</span><span class="text-2xl font-black text-white">${d.conteudo.filmes}</span></div><div class="bg-[#1e293b] p-4 rounded-xl border border-gray-700 flex justify-between items-center"><span class="text-gray-300 font-bold text-sm">Séries</span><span class="text-2xl font-black text-white">${d.conteudo.series}</span></div>`;
        return;
    }
    dadosAtuais = dadosSalvos.d;
    if (dadosAtuais.length === 0) { grid.innerHTML = `<div class="col-span-full text-center text-gray-500">Vazio.</div>`; return; }

    dadosAtuais.forEach(i => {
        if (abaAtual === 'seguranca') {
            let dB = new Date(i.date * 1000); let dF = `${String(dB.getDate()).padStart(2,'0')}/${String(dB.getMonth()+1).padStart(2,'0')} ${String(dB.getHours()).padStart(2,'0')}:${String(dB.getMinutes()).padStart(2,'0')}`;
            html.push(`<div class="bg-red-900 bg-opacity-20 border border-red-800 rounded-xl p-4 flex flex-col justify-between"><div><div class="flex justify-between items-start mb-2"><h3 class="text-lg font-bold text-red-400 truncate"><i class="fas fa-ban mr-2"></i>${i.ip}</h3><span class="bg-red-900 text-white text-[10px] px-2 py-1 rounded">BLOQUEADO</span></div><p class="text-xs text-gray-400 mb-2">Motivo: ${i.notes}</p><p class="text-xs text-gray-500 mb-2">Data: ${dF}</p><div class="flex justify-between text-sm mt-2 p-2 bg-[#0b1120] rounded border border-red-900"><span class="text-gray-400">Tentativas:</span><span class="font-bold text-yellow-500">${i.attempts_blocked}</span></div></div><div class="flex space-x-2 pt-4 mt-auto"><button onclick="excluirRegistro('seguranca',${i.id})" class="w-full bg-green-600 hover:bg-green-500 text-white py-2 rounded text-sm font-bold shadow"><i class="fas fa-unlock mr-2"></i> Desbloquear</button></div></div>`);
        }
        else if (['clientes', 'testes', 'revendedores', 'bouquets'].includes(abaAtual)) {
            if (abaAtual === 'bouquets') { html.push(`<div class="bg-[#1e293b] border border-gray-700 rounded-xl p-4 flex flex-col justify-between"><div><h3 class="text-lg font-bold text-gray-100 truncate"><i class="fas fa-layer-group text-purple-500 mr-2"></i>${i.bouquet_name}</h3></div><div class="flex space-x-2 pt-4 mt-auto border-t border-gray-800"><button onclick="abrirModal(${i.id})" class="flex-1 bg-gray-600 text-white py-2 rounded text-sm">Editar</button><button onclick="excluirRegistro('bouquets',${i.id})" class="flex-1 bg-red-600 text-white py-2 rounded text-sm">Excluir</button></div></div>`); return; }
            const isA = i.enabled == 1; const badge = isA ? `<span class="bg-green-900 bg-opacity-50 text-green-400 text-xs px-2 py-1 rounded">ON</span>` : `<span class="bg-red-900 bg-opacity-50 text-red-400 text-xs px-2 py-1 rounded">OFF</span>`;
            let dE = 'Ilimitado'; if (i.exp_date > 0) { const dO = new Date(i.exp_date * 1000); dE = `${String(dO.getDate()).padStart(2,'0')}/${String(dO.getMonth()+1).padStart(2,'0')}/${dO.getFullYear()}`; }
            html.push(`<div class="bg-[#1e293b] border border-gray-700 rounded-xl p-4 flex flex-col justify-between"><div><div class="flex justify-between items-start mb-2"><h3 class="text-lg font-bold text-gray-100 truncate">${i.username}</h3>${badge}</div><p class="text-xs text-gray-500 mb-2">Senha: ${i.password}</p><div class="flex justify-between text-sm mt-2 p-2 bg-[#0b1120] rounded"><span class="text-gray-400">${abaAtual==='revendedores'?'Créditos':'Vencimento'}</span><span class="font-bold text-white">${abaAtual==='revendedores'?(i.credits||0):dE}</span></div></div><div class="flex space-x-2 pt-4 mt-auto"><button onclick="abrirModal(${i.id})" class="flex-1 bg-gray-600 text-white py-2 rounded"><i class="fas fa-pen"></i></button>${abaAtual==='revendedores'?'':`<button onclick="abrirRenovar(${i.id})" class="flex-1 bg-green-600 text-white py-2 rounded"><i class="fas fa-sync-alt"></i></button><button onclick="abrirInfoModal(${i.id})" class="flex-1 bg-blue-600 text-white py-2 rounded"><i class="fas fa-eye"></i></button>`}<button onclick="alternarStatus(${i.id}, ${i.enabled})" class="flex-1 bg-yellow-600 text-white py-2 rounded"><i class="fas ${isA?'fa-lock':'fa-lock-open'}"></i></button><button onclick="excluirRegistro('${abaAtual}',${i.id})" class="flex-1 bg-red-600 text-white py-2 rounded"><i class="fas fa-trash"></i></button></div></div>`);
        } else {
            const img = i.logo ? `<img src="${i.logo}" class="w-full h-40 object-cover rounded-t-xl" loading="lazy">` : `<div class="w-full h-40 bg-gray-800 flex items-center justify-center rounded-t-xl"><i class="fas fa-image text-4xl text-gray-600"></i></div>`;
            let btnVerEps = abaAtual === 'series' ? `<button onclick="abrirEpisodios(${i.id}, '${i.name.replace(/'/g, "\\'")}')" class="w-full bg-blue-600 text-white py-2 rounded text-sm mb-2 font-bold"><i class="fas fa-list mr-2"></i>Ver Episódios</button>` : '';
            html.push(`<div class="bg-[#1e293b] border border-gray-700 rounded-xl shadow flex flex-col justify-between">${img}<div class="p-4"><h3 class="text-sm font-bold text-white truncate mb-2">${i.name}</h3>${btnVerEps}<div class="flex space-x-2"><button onclick="abrirModal(${i.id})" class="flex-1 bg-gray-600 text-white py-2 rounded text-sm"><i class="fas fa-pen"></i></button><button onclick="abrirMoverConteudo(${i.id}, '${i.name.replace(/'/g, "\\'")}')" class="flex-1 bg-blue-600 text-white py-2 rounded text-sm" title="Mover Categoria"><i class="fas fa-folder-open"></i></button><button onclick="excluirRegistro('${abaAtual}',${i.id})" class="flex-1 bg-red-600 text-white py-2 rounded text-sm"><i class="fas fa-trash"></i></button></div></div></div>`);
        }
    });
    grid.innerHTML = html.join(''); pesquisarGrid(); 
}

function abrirEpisodios(id, nome) { currentSeriesId = id; currentSeriesName = nome; mudarAba('episodios'); }

// === FUNÇÕES DE CATEGORIAS (CRIAR, EDITAR E ORGANIZAR) ===
function abrirNovaCategoria(id = null, nome = '', tipo = 'live') {
    document.getElementById('formCategoria').reset();
    document.getElementById('cat_id').value = id || '';
    if (id) {
        document.getElementById('cat_name').value = nome;
        document.getElementById('cat_type').value = tipo;
        document.getElementById('tituloModalCat').innerText = 'Editar Categoria';
    } else {
        document.getElementById('tituloModalCat').innerText = 'Nova Categoria';
    }
    document.getElementById('modalCategoria').classList.remove('hidden');
}

async function salvarCategoria() {
    const fd = new FormData(document.getElementById('formCategoria'));
    try {
        const res = await fetch(`api.php?action=save&type=categoria`, { method: 'POST', body: fd });
        const json = await res.json();
        if (json.success) {
            fecharModal('modalCategoria');
            await carregarCategorias(); // Recarrega a lista do BD
            renderizarOrganizacaoCategorias(); // Redesenha a tela
        } else { alert(json.msg); }
    } catch(e) { alert("Erro de comunicação."); }
}

function renderizarOrganizacaoCategorias() { 
    const lL=document.getElementById('sortable-live'); const lM=document.getElementById('sortable-movie'); const lS=document.getElementById('sortable-series'); 
    if(!lL)return; lL.innerHTML=''; lM.innerHTML=''; lS.innerHTML=''; 
    
    todasCategorias.forEach(c=>{ 
        // NOVO: Botões de Editar e Excluir dentro da lista de Organizar
        const btnEdit = `<button onclick="abrirNovaCategoria(${c.id}, '${c.category_name.replace(/'/g, "\\'")}', '${c.category_type}')" class="text-blue-400 hover:text-white mr-3"><i class="fas fa-pen"></i></button>`;
        const btnDel = `<button onclick="excluirRegistro('categoria', ${c.id})" class="text-red-500 hover:text-white"><i class="fas fa-trash"></i></button>`;
        
        const i=`<div class="bg-[#1e293b] border border-gray-600 p-3 rounded mb-2 flex items-center shadow" data-id="${c.id}"><i class="fas fa-grip-lines text-gray-500 mr-3 cursor-move"></i><span class="text-gray-200 font-medium truncate text-sm flex-1">${c.category_name}</span>${btnEdit}${btnDel}</div>`; 
        
        let tipo = c.category_type ? c.category_type.toLowerCase() : '';
        if(tipo === 'movie' || tipo === 'vod') { lM.innerHTML += i; } else if(tipo === 'series' || tipo === 'serie') { lS.innerHTML += i; } else { lL.innerHTML += i; } 
    }); 
    new Sortable(lL,{animation:150, handle: '.cursor-move'}); new Sortable(lM,{animation:150, handle: '.cursor-move'}); new Sortable(lS,{animation:150, handle: '.cursor-move'}); 
}

// === MOVER CONTEÚDO (INDIVIDUAL E MASSA) ===
function getCategoriasMistas() {
    let htmlCats = ''; let tA = null;
    todasCategorias.forEach(c => {
        let tipo = c.category_type ? c.category_type.toUpperCase() : 'OUTROS';
        if (tA !== tipo) { if (tA !== null) htmlCats += '</optgroup>'; htmlCats += `<optgroup label="--- ${tipo} ---">`; tA = tipo; }
        htmlCats += `<option value="${c.id}">${c.category_name}</option>`;
    });
    if (tA !== null) htmlCats += '</optgroup>';
    return htmlCats;
}

function abrirMoverConteudo(id, nome) {
    document.getElementById('move_id').value = id; document.getElementById('move_type').value = abaAtual;
    document.getElementById('move_nome').innerText = `Mover: ${nome}`;
    document.getElementById('move_nova_categoria').innerHTML = getCategoriasMistas();
    document.getElementById('modalMover').classList.remove('hidden');
}

async function confirmarMover() {
    const id = document.getElementById('move_id').value; const cat = document.getElementById('move_nova_categoria').value; const tipo = document.getElementById('move_type').value;
    if(!cat) return alert("Selecione o destino!");
    const fd = new FormData(); fd.append('id', id); fd.append('nova_categoria', cat); fd.append('tipo_conteudo', tipo);
    try { await fetch('api.php?action=mover_conteudo', { method: 'POST', body: fd }); fecharModal('modalMover'); cacheDados = {}; carregarDados(true); alert("Movido com sucesso!"); } catch(e) { alert("Erro de comunicação."); }
}

function abrirMoverMassa() {
    const mix = getCategoriasMistas();
    document.getElementById('massa_origem').innerHTML = '<option value="0">Selecione Origem...</option>' + mix;
    document.getElementById('massa_destino').innerHTML = '<option value="0">Selecione Destino...</option>' + mix;
    document.getElementById('modalMoverMassa').classList.remove('hidden');
}

async function confirmarMoverMassa() {
    const o = document.getElementById('massa_origem').value; const d = document.getElementById('massa_destino').value;
    if(o === "0" || d === "0" || o === d) return alert("Selecione categorias válidas e diferentes!");
    if(!confirm("CUIDADO: Isso moverá TODOS os conteúdos da origem para o destino.\nTem certeza absoluta?")) return;
    const btn = document.querySelector('button[onclick="confirmarMoverMassa()"]'); btn.innerHTML = '<i class="fas fa-spinner fa-spin mr-2"></i> Transferindo...'; btn.disabled = true;
    const fd = new FormData(); fd.append('origem', o); fd.append('destino', d);
    try { await fetch('api.php?action=mover_em_massa', { method: 'POST', body: fd }); fecharModal('modalMoverMassa'); cacheDados = {}; carregarCategorias(); carregarDados(true); alert("Transferência completa!"); } catch(e) { alert("Erro de comunicação."); }
    btn.innerHTML = 'Transferir Tudo'; btn.disabled = false;
}

// === MODAIS PADRÕES E TMDB ===
function abrirModal(id = null) {
    if (['canais', 'filmes', 'series', 'episodios'].includes(abaAtual)) {
        document.getElementById('formConteudo').reset(); document.getElementById('c_id').value = id || '';
        const catSelect = document.getElementById('c_categoria'); catSelect.innerHTML = '<option value="0">Sem Categoria</option>';
        const isM = abaAtual==='filmes'; const isS = abaAtual==='series'; const isE = abaAtual==='episodios'; const isC = abaAtual==='canais';
        
        todasCategorias.filter(c => { let t = c.category_type ? c.category_type.toLowerCase() : ''; if (isM) return t === 'movie' || t === 'vod'; if (isS) return t === 'series' || t === 'serie'; return t === 'live'; }).forEach(c => catSelect.innerHTML += `<option value="${c.id}">${c.category_name}</option>`);

        document.getElementById('btnTMDB').classList.toggle('hidden', isC || isE); document.getElementById('divUrl').classList.toggle('hidden', isS); document.getElementById('divCategoria').classList.toggle('hidden', isE); document.getElementById('divEpisodio').classList.toggle('hidden', !isE); document.getElementById('divSinopse').classList.toggle('hidden', isC); document.getElementById('c_series_id').value = isE ? currentSeriesId : ''; document.getElementById('tituloModalConteudo').innerText = id ? `Editar` : `Novo`;
        if (id) {
            const d = dadosAtuais.find(x => x.id == id); if(!d) return; document.getElementById('c_nome').value = d.name || ''; document.getElementById('c_logo').value = d.logo || '';
            if(d.url) { try { document.getElementById('c_url').value = JSON.parse(d.url)[0]; } catch(e) { document.getElementById('c_url').value = d.url; } }
            if(d.category_id) catSelect.value = d.category_id; if(d.plot) document.getElementById('c_plot').value = d.plot;
            if(d.props) { try{ const p = JSON.parse(d.props); document.getElementById('c_plot').value = p.plot||''; document.getElementById('c_season').value = p.season||1; document.getElementById('c_episode').value = p.episode||1; }catch(e){} }
        } document.getElementById('modalConteudo').classList.remove('hidden');
    } else {
        const modal = document.getElementById('formModal'); document.getElementById('mainForm').reset();
        ['camposRevenda','camposCliente','camposBouquet'].forEach(c => { document.getElementById(c).classList.add('hidden'); }); document.getElementById('divUserPass').classList.remove('hidden'); 
        if (abaAtual === 'revendedores') document.getElementById('camposRevenda').classList.remove('hidden'); else if (abaAtual === 'bouquets') { document.getElementById('camposBouquet').classList.remove('hidden'); document.getElementById('divUserPass').classList.add('hidden'); } else document.getElementById('camposCliente').classList.remove('hidden');
        if (id) {
            const d = dadosAtuais.find(x => x.id == id); if (!d) return; document.getElementById('modalTitle').innerText = "Editar Registro"; document.getElementById('formId').value = d.id;
            if (abaAtual === 'bouquets') { document.getElementById('formBouquetName').value = d.bouquet_name; renderizarCategorias(d.category_ids||[]); } 
            else { document.getElementById('formUser').value = d.username; document.getElementById('formPass').value = d.password; if(abaAtual === 'revendedores') { document.getElementById('formEmail').value = d.email||''; document.getElementById('formCredits').value = d.credits||0; } else { if (d.exp_date > 0) { const dt = new Date(d.exp_date * 1000); document.getElementById('formVencimento').value = `${dt.getFullYear()}-${String(dt.getMonth() + 1).padStart(2, '0')}-${String(dt.getDate()).padStart(2, '0')}`; } let a = []; try { a = JSON.parse(d.bouquet); if(!Array.isArray(a))a=[]; } catch(e){} renderizarBouquets(a); } }
        } else { document.getElementById('modalTitle').innerText = "Novo Registro"; document.getElementById('formId').value = ''; document.getElementById('formVencimento').value = ''; if (abaAtual === 'bouquets') renderizarCategorias([]); else renderizarBouquets([]); }
        modal.classList.remove('hidden');
    }
}

async function abrirPesquisaTMDB() { const nome = document.getElementById('c_nome').value; if(!nome) return alert('Digite o título!'); const btn = document.getElementById('btnTMDB'); btn.innerHTML = '<i class="fas fa-spinner fa-spin"></i>'; btn.disabled = true; const fd = new FormData(); fd.append('titulo', nome); fd.append('tipo', abaAtual==='filmes'?'movie':'tv'); try { const res = await fetch('api.php?action=buscar_tmdb_manual', {method:'POST',body:fd}); const j = await res.json(); if(j.success && j.data.length > 0) { const grid = document.getElementById('grid-tmdb'); grid.innerHTML = ''; j.data.forEach(item => { const img = item.cover ? `<img src="${item.cover}" class="w-full h-40 object-cover rounded-t-lg">` : `<div class="w-full h-40 bg-gray-800 flex items-center justify-center rounded-t-lg"><i class="fas fa-image text-gray-600"></i></div>`; grid.innerHTML += `<div class="bg-[#0f172a] border border-gray-600 rounded-lg cursor-pointer hover:border-blue-500 transition-colors flex flex-col" onclick="selecionarTMDB('${item.cover}', '${item.plot}')">${img}<div class="p-2 text-center"><p class="text-xs font-bold text-gray-200 truncate">${item.title}</p></div></div>`; }); document.getElementById('modalTMDB').classList.remove('hidden'); } else { alert("Nenhum resultado."); } } catch(e) { alert("Erro de conexão."); } btn.innerHTML = '<i class="fas fa-search mr-2"></i>TMDB'; btn.disabled = false; }
function selecionarTMDB(cover, plot) { if(cover && cover !== 'null') document.getElementById('c_logo').value = cover; if(plot && plot !== 'null') document.getElementById('c_plot').value = plot; fecharModal('modalTMDB'); }

// === SALVAR E EXCLUIR GERAL ===
async function salvarConteudo() { const fd = new FormData(document.getElementById('formConteudo')); let actionType = abaAtual; if(abaAtual==='canais') actionType='canal'; if(abaAtual==='filmes') actionType='filme'; if(abaAtual==='series') actionType='serie'; if(abaAtual==='episodios') actionType='episodio'; try { const res = await fetch(`api.php?action=save&type=${actionType}`, { method: 'POST', body: fd }); const j = await res.json(); if(j.success){ fecharModal('modalConteudo'); cacheDados={}; carregarDados(true); } else alert(j.msg); } catch(e){ alert('Erro ao salvar'); } }
async function salvarDados() { const fd = new FormData(document.getElementById('mainForm')); try { const res = await fetch(`api.php?action=save&type=${abaAtual}`, { method: 'POST', body: fd }); const j = await res.json(); if (j.success) { fecharModal('formModal'); cacheDados={}; carregarDados(true); if(abaAtual === 'bouquets') carregarBouquets(); } else alert(j.msg); } catch(e) { alert("Erro."); } }
async function excluirRegistro(tipo, id) { if(!confirm("TEM CERTEZA?")) return; const fd = new FormData(); fd.append('id', id); await fetch(`api.php?action=delete&type=${tipo}`, { method: 'POST', body: fd }); cacheDados={}; if(tipo==='categoria') { carregarCategorias(); setTimeout(()=>renderizarOrganizacaoCategorias(), 500); } else { carregarDados(true); } }

function renderizarBouquets(userBouquets = []) { const list = document.getElementById('bouquetsList'); if(!list) return; list.innerHTML = ''; if(todosBouquets.length === 0) { list.innerHTML = '<span class="text-xs text-gray-500">Vazio.</span>'; return; } let html = `<div class="flex space-x-2 mb-3 sticky top-0 bg-[#0f172a] py-1 z-10 border-b border-gray-700 pb-2"><button type="button" onclick="marcarTodos('bouquets[]', true)" class="bg-blue-600 text-white text-[11px] px-3 py-1.5 rounded">Todas</button><button type="button" onclick="marcarTodos('bouquets[]', false)" class="bg-gray-600 text-white text-[11px] px-3 py-1.5 rounded">Nenhuma</button></div>`; todosBouquets.forEach(b => { const c = userBouquets.some(id => Number(id) === Number(b.id)) ? 'checked' : ''; html += `<label class="flex items-center space-x-3 cursor-pointer p-1.5 hover:bg-gray-800 rounded"><input type="checkbox" name="bouquets[]" value="${b.id}" ${c} class="form-checkbox h-4 w-4 text-blue-600 bg-gray-900 border-gray-600 rounded"><span class="text-sm text-gray-300 truncate">${b.bouquet_name}</span></label>`; }); list.innerHTML = html; }
function renderizarCategorias(marcadas = []) { const list = document.getElementById('categoriasList'); if(!list) return; list.innerHTML = ''; if(todasCategorias.length === 0) { list.innerHTML = '<span class="text-xs text-gray-500">Vazio.</span>'; return; } let html = `<div class="flex space-x-2 mb-2 sticky top-0 bg-[#0f172a] py-1 z-10 border-b border-gray-700 pb-2"><button type="button" onclick="marcarTodos('categorias[]', true)" class="bg-blue-600 text-white text-[11px] px-3 py-1.5 rounded">Todas</button><button type="button" onclick="marcarTodos('categorias[]', false)" class="bg-gray-600 text-white text-[11px] px-3 py-1.5 rounded">Nenhuma</button></div>`; let tA = ''; todasCategorias.forEach(c => { if (tA !== c.category_type) { html += `<div class="font-bold text-gray-400 text-xs uppercase mt-3 mb-1 pb-1 border-b border-gray-700">${c.category_type || 'outros'}</div>`; tA = c.category_type; } const cChecked = marcadas.some(id => Number(id) === Number(c.id)) ? 'checked' : ''; html += `<label class="flex items-center space-x-3 cursor-pointer p-1 hover:bg-gray-800 rounded ml-2"><input type="checkbox" name="categorias[]" value="${c.id}" ${cChecked} class="form-checkbox h-4 w-4 text-blue-600 bg-gray-900 border-gray-600 rounded"><span class="text-sm text-gray-300 truncate">${c.category_name}</span></label>`; }); list.innerHTML = html; }

async function salvarOrdemCategorias() { const btn=document.querySelector('button[onclick="salvarOrdemCategorias()"]'); const txt=btn.innerHTML; btn.innerHTML='<i class="fas fa-spinner fa-spin"></i>'; btn.disabled=true; let o=[]; document.querySelectorAll('#sortable-live > div').forEach((e,i)=>o.push({id:e.getAttribute('data-id'),order:i})); document.querySelectorAll('#sortable-movie > div').forEach((e,i)=>o.push({id:e.getAttribute('data-id'),order:i})); document.querySelectorAll('#sortable-series > div').forEach((e,i)=>o.push({id:e.getAttribute('data-id'),order:i})); const fd=new FormData(); fd.append('ordem',JSON.stringify(o)); try{ await fetch('api.php?action=salvar_ordem_categorias',{method:'POST',body:fd}); alert("Ordem Salva!"); carregarCategorias(); }catch(e){} btn.innerHTML=txt; btn.disabled=false; }
function renderizarCategoriasApagar() { const list=document.getElementById('lista-categorias-apagar'); if(!list)return; list.innerHTML=''; let html=`<div class="flex space-x-2 mb-3 bg-[#1e293b] py-2 sticky top-0 z-10 border-b border-gray-700"><button type="button" onclick="marcarTodos('delete_cat[]', true)" class="bg-blue-600 text-white px-3 py-2 rounded text-xs">Todas</button><button type="button" onclick="marcarTodos('delete_cat[]', false)" class="bg-gray-600 text-white px-3 py-2 rounded text-xs">Nenhuma</button></div>`; todasCategorias.forEach(c => { html += `<label class="flex items-center space-x-3 cursor-pointer p-2 hover:bg-gray-800 rounded ml-2"><input type="checkbox" name="delete_cat[]" value="${c.id}" class="form-checkbox h-5 w-5 text-red-600"><span class="text-sm font-medium text-gray-300 truncate">${c.category_name}</span></label>`; }); list.innerHTML=html; }
async function apagarCategoriasSelecionadas() { const m=Array.from(document.querySelectorAll('input[name="delete_cat[]"]:checked')).map(cb=>cb.value); if(m.length===0)return; if(!confirm("Excluir?"))return; const fd=new FormData(); fd.append('categorias',JSON.stringify(m)); fd.append('tipo_exclusao','selecionados'); try{ await fetch('api.php?action=apagar_conteudos',{method:'POST',body:fd}); alert("Apagado!"); await carregarCategorias(); cacheDados={}; renderizarCategoriasApagar(); }catch(e){} }
async function apagarTodoConteudo() { if(!confirm("APAGAR TUDO?"))return; const fd=new FormData(); fd.append('tipo_exclusao','tudo'); try{ await fetch('api.php?action=apagar_conteudos',{method:'POST',body:fd}); alert("Limpo!"); todasCategorias=[]; cacheDados={}; renderizarCategoriasApagar(); }catch(e){} }
async function apagarDuplicados() { if (!confirm("Remover duplicados mantendo um único registro de cada?")) return; const btn = document.getElementById('btn-apagar-duplicados'); const txt = btn.innerHTML; btn.innerHTML = '<i class="fas fa-spinner fa-spin mr-2"></i> Limpando...'; btn.disabled = true; try { const res = await fetch('api.php?action=apagar_duplicados', { method: 'POST' }); const json = await res.json(); alert(json.msg); cacheDados = {}; } catch(e) { alert("Limpeza em segundo plano..."); } btn.innerHTML = txt; btn.disabled = false; }

async function lerCategoriasM3U() { const url=document.getElementById('m3u_url_input').value; if(!url)return; const btn=document.getElementById('btn-ler-m3u'); btn.innerHTML='...'; btn.disabled=true; const fd=new FormData(); fd.append('url_m3u',url); try{ const res=await fetch('api.php?action=ler_m3u',{method:'POST',body:fd}); const j=await res.json(); if(j.success){ const l=document.getElementById('lista-categorias-m3u'); l.innerHTML=''; j.data.forEach(c=>{ l.innerHTML+=`<label class="flex items-center space-x-3 cursor-pointer p-2"><input type="checkbox" name="import_cat[]" value="${c}" class="form-checkbox h-5 w-5 text-green-600"><span class="text-sm text-gray-200">${c}</span></label>`; }); document.getElementById('area-categorias-m3u').classList.remove('hidden'); } }catch(e){} btn.innerHTML='Ler'; btn.disabled=false; }
function iniciarMonitoramentoLog() { document.getElementById('area-log').classList.remove('hidden'); logIntervalo=setInterval(async()=>{ try{ const res=await fetch('api.php?action=get_log'); const d=await res.json(); if(d.total>0) document.getElementById('barra-progresso').style.width=`${Math.min(100,Math.round((d.atual/d.total)*100))}%`; document.getElementById('texto-log').innerText=d.msg; if(d.msg.includes("Concluído"))clearInterval(logIntervalo); }catch(e){} },1500); }
async function iniciarImportacaoM3U() { const url=document.getElementById('m3u_url_input').value; const m=Array.from(document.querySelectorAll('input[name="import_cat[]"]:checked')).map(cb=>cb.value); if(m.length===0)return; const btn=document.getElementById('btn-iniciar-importacao'); btn.disabled=true; iniciarMonitoramentoLog(); const fd=new FormData(); fd.append('url_m3u',url); fd.append('categorias',JSON.stringify(m)); try{ const res=await fetch('api.php?action=importar_m3u',{method:'POST',body:fd}); const j=await res.json(); clearInterval(logIntervalo); alert(j.msg); carregarCategorias(); cacheDados={}; }catch(e){} btn.disabled=false; }

function abrirRenovar(id) { document.getElementById('renewId').value = id; document.getElementById('renewModal').classList.remove('hidden'); }
async function confirmarRenovacao() { const fd = new FormData(); fd.append('id', document.getElementById('renewId').value); fd.append('meses', document.getElementById('renewMeses').value); await fetch(`api.php?action=renew`, { method: 'POST', body: fd }); fecharModal('renewModal'); cacheDados={}; carregarDados(true); }
function abrirInfoModal(id) { const item = dadosAtuais.find(d => d.id == id); if (!item) return; const m3uLink = `${serverUrl}/get.php?username=${item.username}&password=${item.password}&type=m3u_plus&output=mpegts`; document.getElementById('textoInfo').value = `Usuário: ${item.username}\nSenha: ${item.password}\nLink:\n${m3uLink}`; document.getElementById('infoModal').classList.remove('hidden'); }
function copiarInfo() { const t = document.getElementById('textoInfo'); t.select(); navigator.clipboard.writeText(t.value); alert("Copiado!"); }
function enviarWhatsApp() { window.open(`https://api.whatsapp.com/send?text=${encodeURIComponent(document.getElementById('textoInfo').value)}`, '_blank'); }
async function alternarStatus(id, s) { if(!confirm("Confirmar?"))return; const fd = new FormData(); fd.append('id', id); fd.append('status', s); await fetch(`api.php?action=toggle&type=${abaAtual}`, { method: 'POST', body: fd }); cacheDados={}; carregarDados(true); }
