<?php
// login.php
require_once 'config.php';

// SISTEMA ANTI-LOOPING: Usa o JavaScript para substituir o histórico em vez do header do PHP
if (isset($_SESSION['logado']) && $_SESSION['logado'] === true) {
    echo "<script>window.location.replace('index.php');</script>";
    exit;
}

$erro = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $usuario = $_POST['username'] ?? '';
    $senha = $_POST['password'] ?? '';

    // Busca o usuário na tabela de revendedores/admins do Xtream UI
    $stmt = $pdo->prepare("SELECT id, username, password, member_group_id FROM reg_users WHERE username = ?");
    $stmt->execute([$usuario]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    // Verifica a senha (cobre texto puro, MD5 ou crypt usados pelo Xtream UI)
    if ($user && ($senha === $user['password'] || md5($senha) === $user['password'] || password_verify($senha, $user['password']))) {
        
        $_SESSION['logado'] = true;
        $_SESSION['user_id'] = $user['id']; // ID do revendedor/admin
        $_SESSION['username'] = $user['username'];
        // member_group_id = 1 normalmente é o Admin Mestre no Xtream UI
        $_SESSION['is_admin'] = ($user['member_group_id'] == 1); 
        
        // Redirecionamento limpo para o painel
        echo "<script>window.location.replace('index.php');</script>";
        exit;
    } else {
        $erro = 'Usuário ou senha incorretos, ou conta desativada!';
    }
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - Painel Gestor</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        html, body { background-color: #0f172a !important; color: #f8fafc; height: 100vh; overflow: hidden; }
        input:-webkit-autofill { -webkit-box-shadow: 0 0 0 30px #1e293b inset !important; -webkit-text-fill-color: white !important; }
    </style>
</head>
<body class="flex items-center justify-center p-4">
    <div class="w-full max-w-sm bg-[#1e293b] border border-gray-700 rounded-2xl shadow-2xl p-8">
        <div class="text-center mb-8">
            <div class="inline-block bg-[#0b1120] p-4 rounded-full border border-gray-700 mb-4 shadow-lg">
                <i class="fas fa-bolt text-4xl text-yellow-500"></i>
            </div>
            <h1 class="text-2xl font-bold text-white tracking-wider">PAINEL GESTOR</h1>
        </div>

        <?php if ($erro): ?>
            <div class="bg-red-900 bg-opacity-50 border border-red-700 text-red-400 p-3 rounded-lg text-sm mb-4 text-center">
                <i class="fas fa-exclamation-triangle mr-1"></i> <?= $erro ?>
            </div>
        <?php endif; ?>

        <form method="POST" class="space-y-5">
            <div>
                <div class="relative">
                    <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none"><i class="fas fa-user text-gray-500"></i></div>
                    <input type="text" name="username" placeholder="Usuário" class="w-full bg-[#0f172a] border border-gray-600 rounded-lg py-3 pl-10 pr-3 text-white focus:outline-none focus:border-blue-500" required>
                </div>
            </div>
            <div>
                <div class="relative">
                    <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none"><i class="fas fa-lock text-gray-500"></i></div>
                    <input type="password" name="password" placeholder="Senha" class="w-full bg-[#0f172a] border border-gray-600 rounded-lg py-3 pl-10 pr-3 text-white focus:outline-none focus:border-blue-500" required>
                </div>
            </div>
            <button type="submit" class="w-full bg-blue-600 hover:bg-blue-500 text-white font-bold py-3 rounded-lg shadow-[0_0_15px_rgba(37,99,235,0.4)] mt-2 transition-colors">ENTRAR <i class="fas fa-sign-in-alt ml-2"></i></button>
        </form>
    </div>
</body>
</html>
