<?php
// api.php
error_reporting(0); ini_set('display_errors', 0); header('Content-Type: application/json'); require_once 'config.php';
if (!isset($_SESSION['logado']) || $_SESSION['logado'] !== true) { die(json_encode(['success' => false, 'msg' => 'Sessão inválida', 'logout' => true])); }

$action = $_GET['action'] ?? ''; $type = $_GET['type'] ?? 'clientes';
$user_id = $_SESSION['user_id']; $is_admin = $_SESSION['is_admin'];
$filtro_clientes = $is_admin ? "" : " AND member_id = $user_id"; $filtro_revenda  = $is_admin ? "" : " WHERE owner_id = $user_id";

function verificarPosse($pdo, $id, $uid, $adm, $tabela) { if ($adm) return true; return ($pdo->query("SELECT " . ($tabela === 'reg_users' ? "owner_id" : "member_id") . " FROM $tabela WHERE id = $id")->fetchColumn() == $uid); }
function baixarArquivo($url) { $ch = curl_init(); curl_setopt($ch, CURLOPT_URL, $url); curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true); curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); curl_setopt($ch, CURLOPT_TIMEOUT, 300); curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0'); $res = curl_exec($ch); curl_close($ch); return $res; }
function buscarTMDB($titulo, $tipo) { if (!defined('TMDB_API_KEY') || empty(TMDB_API_KEY)) return ['cover' => '', 'plot' => '']; $tit = trim(preg_replace('/(\d{4}|1080p|720p|4k|dual|dublado|legendado|aac|h264|hevc|mkv|mp4|\(.*\)|\[.*\]|-|_)/i', '', $titulo)); $res = baixarArquivo("https://api.themoviedb.org/3/search/$tipo?api_key=" . TMDB_API_KEY . "&query=" . urlencode($tit) . "&language=pt-BR"); $data = json_decode($res, true); if (!empty($data['results'][0])) { $i = $data['results'][0]; return ['cover' => !empty($i['poster_path']) ? "https://image.tmdb.org/t/p/w500" . $i['poster_path'] : '', 'plot' => $i['overview'] ?? '']; } return ['cover' => '', 'plot' => '']; }
function atualizarLog($t, $a, $m) { file_put_contents('import_log.json', json_encode(['total' => $t, 'atual' => $a, 'msg' => $m])); }

try {
    if ($action === 'get_log') { if (file_exists('import_log.json')) echo file_get_contents('import_log.json'); else echo json_encode(['total' => 0, 'atual' => 0, 'msg' => 'Aguardando...']); exit; }
    
    if ($action === 'mover_conteudo') { if (!$is_admin) die(); $id = (int)$_POST['id']; $nova_categoria = (int)$_POST['nova_categoria']; $tipo_conteudo = $_POST['tipo_conteudo']; if ($tipo_conteudo === 'series') { $pdo->prepare("UPDATE series SET category_id = ? WHERE id = ?")->execute([$nova_categoria, $id]); } else { $pdo->prepare("UPDATE streams SET category_id = ? WHERE id = ?")->execute([$nova_categoria, $id]); } echo json_encode(['success' => true, 'msg' => 'Movido com sucesso!']); exit; }
    if ($action === 'mover_em_massa') { if (!$is_admin) die(); $origem = (int)$_POST['origem']; $destino = (int)$_POST['destino']; if ($origem === 0 || $destino === 0 || $origem === $destino) die(json_encode(['success' => false, 'msg' => 'Selecione categorias válidas.'])); $pdo->prepare("UPDATE streams SET category_id = ? WHERE category_id = ?")->execute([$destino, $origem]); $pdo->prepare("UPDATE series SET category_id = ? WHERE category_id = ?")->execute([$destino, $origem]); echo json_encode(['success' => true, 'msg' => 'Transferência em massa concluída!']); exit; }

    if ($action === 'buscar_tmdb_manual') { if (!$is_admin) die(); $tit = trim(preg_replace('/(\d{4}|1080p|720p|4k|dual|dublado|legendado|aac|h264|hevc|mkv|mp4|\(.*\)|\[.*\]|-|_)/i', '', $_POST['titulo'] ?? '')); $tipo = $_POST['tipo'] ?? 'movie'; $res = baixarArquivo("https://api.themoviedb.org/3/search/$tipo?api_key=" . TMDB_API_KEY . "&query=" . urlencode($tit) . "&language=pt-BR"); $data = json_decode($res, true); $results = []; if (!empty($data['results'])) { foreach (array_slice($data['results'], 0, 8) as $i) { $c = !empty($i['poster_path']) ? "https://image.tmdb.org/t/p/w500" . $i['poster_path'] : ''; $n = $i['title'] ?? $i['name'] ?? 'Sem Título'; $y = isset($i['release_date']) ? substr($i['release_date'], 0, 4) : (isset($i['first_air_date']) ? substr($i['first_air_date'], 0, 4) : ''); $plot = str_replace(["\r", "\n", '"', "'", "`"], [" ", " ", "", "", ""], $i['overview'] ?? ''); $results[] = ['title' => $n . ($y ? " ($y)" : ''), 'cover' => $c, 'plot' => $plot]; } } echo json_encode(['success' => true, 'data' => $results]); exit; }

    if ($action === 'salvar_ordem_categorias') { if (!$is_admin) die(); $ordem = json_decode($_POST['ordem'] ?? '[]', true); if (empty($ordem)) die(); $pdo->beginTransaction(); try { $stmt = $pdo->prepare("UPDATE stream_categories SET cat_order = ? WHERE id = ?"); foreach ($ordem as $i) { $stmt->execute([(int)$i['order'], (int)$i['id']]); } $pdo->commit(); echo json_encode(['success' => true, 'msg' => 'Ordem salva!']); } catch (Exception $e) { $pdo->rollBack(); } exit; }
    if ($action === 'apagar_duplicados') { if (!$is_admin) die(json_encode(['success' => false, 'msg' => 'Acesso negado'])); ini_set('memory_limit', '-1'); set_time_limit(0); session_write_close(); try { $stmt = $pdo->query("SELECT id, stream_display_name, category_id, type, series_no FROM streams ORDER BY id ASC"); $vistos = []; $apagar = []; while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) { $chave = md5($row['stream_display_name'] . '|' . $row['category_id'] . '|' . $row['type'] . '|' . $row['series_no']); if (isset($vistos[$chave])) { $apagar[] = $row['id']; } else { $vistos[$chave] = true; } } $t1 = count($apagar); if ($t1 > 0) { foreach (array_chunk($apagar, 50) as $chunk) { $in = implode(',', $chunk); $pdo->exec("DELETE FROM streams WHERE id IN ($in)"); usleep(50000); } } $stmtS = $pdo->query("SELECT id, title, category_id FROM series ORDER BY id ASC"); $vistosS = []; $apagarS = []; while ($row = $stmtS->fetch(PDO::FETCH_ASSOC)) { $chave = md5($row['title'] . '|' . $row['category_id']); if (isset($vistosS[$chave])) { $apagarS[] = $row['id']; } else { $vistosS[$chave] = true; } } $t2 = count($apagarS); if ($t2 > 0) { foreach (array_chunk($apagarS, 50) as $chunk) { $in = implode(',', $chunk); $pdo->exec("DELETE FROM series WHERE id IN ($in)"); usleep(50000); } } echo json_encode(['success' => true, 'msg' => "Limpeza concluída! " . ($t1 + $t2) . " duplicados apagados."]); } catch(Exception $e) { echo json_encode(['success' => false, 'msg' => 'Erro: ' . $e->getMessage()]); } exit; }
    if ($action === 'apagar_conteudos') { if (!$is_admin) die(); $t = $_POST['tipo_exclusao'] ?? ''; if ($t === 'tudo') { $pdo->exec("TRUNCATE TABLE stream_categories"); $pdo->exec("TRUNCATE TABLE streams"); $pdo->exec("TRUNCATE TABLE series"); echo json_encode(['success' => true, 'msg' => 'TUDO APAGADO!']); exit; } if ($t === 'selecionados') { $cats = json_decode($_POST['categorias'] ?? '[]'); if (empty($cats)) die(); $in = implode(',', array_map('intval', $cats)); $pdo->exec("DELETE FROM streams WHERE category_id IN ($in)"); $pdo->exec("DELETE FROM series WHERE category_id IN ($in)"); $pdo->exec("DELETE FROM stream_categories WHERE id IN ($in)"); echo json_encode(['success' => true, 'msg' => 'Excluído com sucesso!']); exit; } }
    if ($action === 'ler_m3u') { if (!$is_admin) die(); ini_set('memory_limit', '-1'); set_time_limit(0); $url = $_POST['url_m3u'] ?? ''; $conteudo = baixarArquivo($url); if (!$conteudo) die(); preg_match_all('/group-title="([^"]+)"/i', $conteudo, $m); if (empty($m[1])) die(); $cats = array_values(array_unique($m[1])); sort($cats); echo json_encode(['success' => true, 'data' => $cats]); exit; }
    
    if ($action === 'importar_m3u') {
        if (!$is_admin) die(); ini_set('memory_limit', '-1'); set_time_limit(0); $url = $_POST['url_m3u'] ?? ''; $categorias_selecionadas = json_decode($_POST['categorias'] ?? '[]');
        if (empty($categorias_selecionadas)) die(); atualizarLog(0, 0, "Baixando lista M3U..."); $conteudo = baixarArquivo($url); if (!$conteudo) die(json_encode(['success' => false, 'msg' => 'Falha ao baixar.']));
        $linhas = explode("\n", $conteudo); $total_linhas = count($linhas); $item_atual = []; $qtd = 0; $cache_tmdb = []; $cache_series_db = [];
        $stmtCat = $pdo->prepare("INSERT INTO stream_categories (category_type, category_name, parent_id) VALUES (?, ?, 0)"); $stmtMovie = $pdo->prepare("INSERT INTO streams (type, category_id, stream_display_name, stream_source, stream_icon, movie_propeties, target_container) VALUES (2, ?, ?, ?, ?, ?, ?)"); $stmtLive = $pdo->prepare("INSERT INTO streams (type, category_id, stream_display_name, stream_source, stream_icon, target_container) VALUES (1, ?, ?, ?, ?, ?)"); $stmtSeries = $pdo->prepare("INSERT INTO series (title, category_id, cover, plot, releaseDate) VALUES (?, ?, ?, ?, NOW())"); $stmtEpisode = $pdo->prepare("INSERT INTO streams (type, category_id, stream_display_name, stream_source, stream_icon, movie_propeties, target_container, series_no) VALUES (5, ?, ?, ?, ?, ?, ?, ?)");
        for ($i = 0; $i < $total_linhas; $i++) {
            $linha = trim($linhas[$i]); if (empty($linha)) continue;
            if ($i % 50 === 0) atualizarLog($total_linhas, $i, "Processando: " . ($item_atual['name'] ?? '...'));
            if (strpos($linha, '#EXTINF') === 0) { preg_match('/group-title="([^"]+)"/i', $linha, $c); preg_match('/tvg-logo="([^"]+)"/i', $linha, $l); $p = explode(',', $linha); $item_atual = ['cat' => $c[1] ?? 'Sem Categoria', 'logo' => $l[1] ?? '', 'name' => trim(end($p))]; } 
            elseif (strpos($linha, 'http') === 0 && !empty($item_atual)) {
                if (in_array($item_atual['cat'], $categorias_selecionadas)) {
                    $nome = $item_atual['name']; $url_enc = json_encode([$linha]); $is_series = false; $season = 1; $ep = 1; $nome_s = $nome;
                    if (preg_match('/(?:S|T)\s*(\d{1,2})\s*(?:E|EP)\s*(\d{1,3})/i', $nome, $m) || preg_match('/(?:Season|Temporada)\s*(\d{1,2})\s*(?:Episode|Episodio|Ep)\s*(\d{1,3})/i', $nome, $m)) { $is_series = true; $season = (int)$m[1]; $ep = (int)$m[2]; $nome_s = trim(preg_replace('/(?:S|T)\s*\d{1,2}\s*(?:E|EP)\s*\d{1,3}.*$/i', '', $nome)); }
                    $tipo_cat = $is_series ? 'series' : (preg_match('/\.(mp4|mkv|avi|mov)$/i', $linha) ? 'movie' : 'live'); $cat_id = $pdo->query("SELECT id FROM stream_categories WHERE category_name = " . $pdo->quote($item_atual['cat']))->fetchColumn(); if (!$cat_id) { $stmtCat->execute([$tipo_cat, $item_atual['cat']]); $cat_id = $pdo->lastInsertId(); }
                    if ($is_series) { if (!isset($cache_series_db[$nome_s])) { if (!isset($cache_tmdb[$nome_s])) $cache_tmdb[$nome_s] = buscarTMDB($nome_s, 'tv'); $tmdb = $cache_tmdb[$nome_s]; $capa = !empty($tmdb['cover']) ? $tmdb['cover'] : $item_atual['logo']; $stmtSeries->execute([$nome_s, $cat_id, $capa, $tmdb['plot']]); $cache_series_db[$nome_s] = $pdo->lastInsertId(); } $sid = $cache_series_db[$nome_s]; $prop = json_encode(['season' => $season, 'episode' => $ep, 'plot' => $cache_tmdb[$nome_s]['plot'] ?? '']); $cont = preg_match('/\.(mp4|mkv|avi|mov)$/i', $linha, $cx) ? $cx[1] : 'mp4'; try { $stmtEpisode->execute([$cat_id, $nome, $url_enc, $item_atual['logo'], $prop, $cont, $sid]); $qtd++; } catch(Exception $e) {}
                    } else if ($tipo_cat === 'movie') { $tmdb = buscarTMDB($nome, 'movie'); $capa = !empty($tmdb['cover']) ? $tmdb['cover'] : $item_atual['logo']; $prop = json_encode(['plot' => $tmdb['plot'] ?? '', 'movie_image' => $capa]); $cont = preg_match('/\.(mp4|mkv|avi|mov)$/i', $linha, $cx) ? $cx[1] : 'mp4'; try { $stmtMovie->execute([$cat_id, $nome, $url_enc, $capa, $prop, $cont]); $qtd++; } catch(Exception $e) {}
                    } else { try { $stmtLive->execute([$cat_id, $nome, $url_enc, $item_atual['logo'], '["apple"]']); $qtd++; } catch(Exception $e) {} }
                } $item_atual = []; 
            }
        } atualizarLog($total_linhas, $total_linhas, "Concluído! $qtd importados."); echo json_encode(['success' => true, 'msg' => "$qtd conteúdos importados!"]); exit;
    }

    // ==========================================
    // NOVO: DASHBOARD COM STATUS DO SERVIDOR
    // ==========================================
    if ($action === 'dashboard_stats') { 
        $now = time(); $c = function($q) use ($pdo) { return $pdo->query($q)->fetchColumn(); }; 
        $stats = [
            'is_admin' => $is_admin, 
            'clientes' => ['ativos' => $c("SELECT COUNT(id) FROM users WHERE is_trial = 0 AND enabled = 1 AND (exp_date > $now OR exp_date = 0 OR exp_date IS NULL) $filtro_clientes"), 'vencidos' => $c("SELECT COUNT(id) FROM users WHERE is_trial = 0 AND exp_date < $now AND exp_date > 0 $filtro_clientes"), 'bloqueados' => $c("SELECT COUNT(id) FROM users WHERE is_trial = 0 AND enabled = 0 $filtro_clientes")], 
            'testes' => ['ativos' => $c("SELECT COUNT(id) FROM users WHERE is_trial = 1 AND enabled = 1 AND (exp_date > $now OR exp_date = 0 OR exp_date IS NULL) $filtro_clientes"), 'vencidos' => $c("SELECT COUNT(id) FROM users WHERE is_trial = 1 AND exp_date < $now AND exp_date > 0 $filtro_clientes"), 'bloqueados' => $c("SELECT COUNT(id) FROM users WHERE is_trial = 1 AND enabled = 0 $filtro_clientes")], 
            'conteudo' => ['canais' => $c("SELECT COUNT(id) FROM streams WHERE type IN (1, 3)"), 'filmes' => $c("SELECT COUNT(id) FROM streams WHERE type = 2"), 'series' => $c("SELECT COUNT(id) FROM series")]
        ];
        
        // Pega as infos do servidor SOMENTE se for admin
        if ($is_admin) {
            $cpu = 0; if(function_exists('sys_getloadavg')) { $l = sys_getloadavg(); $cpu = min(100, round($l[0] * 10, 1)); }
            $meminfo = @file_get_contents("/proc/meminfo"); $rp = 0; $rs = "0/0 GB"; 
            if($meminfo) { 
                preg_match_all('/^MemTotal:\s+(\d+)\skB/m', $meminfo, $mt); 
                preg_match_all('/^MemAvailable:\s+(\d+)\skB/m', $meminfo, $ma); 
                if(empty($ma[1][0])) preg_match_all('/^MemFree:\s+(\d+)\skB/m', $meminfo, $ma); 
                $tot = $mt[1][0]??0; $avl = $ma[1][0]??0; 
                if($tot>0){ $usd = $tot-$avl; $rp = round(($usd/$tot)*100); $rs = round($usd/1048576, 1)." / ".round($tot/1048576, 1)." GB"; } 
            }
            $dt = @disk_total_space("/"); $df = @disk_free_space("/"); $dp = 0; $ds = "0/0 GB"; 
            if($dt>0){ $du = $dt-$df; $dp = round(($du/$dt)*100); $ds = round($du/1073741824, 1)." / ".round($dt/1073741824, 1)." GB"; }
            $up = @file_get_contents('/proc/uptime'); $us = "0 dias"; 
            if($up){ $ua = explode(' ', $up); $us = floor($ua[0]/86400)." dias"; }
            
            $stats['server'] = ['cpu' => $cpu, 'ram_p' => $rp, 'ram_s' => $rs, 'disk_p' => $dp, 'disk_s' => $ds, 'up' => $us];
        }
        
        echo json_encode(['success' => true, 'data' => $stats]); exit; 
    }

    if ($action === 'get_categories') { try { $stmt = $pdo->query("SELECT id, category_name, category_type, cat_order FROM stream_categories ORDER BY category_type ASC, cat_order ASC, category_name ASC"); echo json_encode(['success' => true, 'data' => $stmt->fetchAll(PDO::FETCH_ASSOC)]); } catch(Exception $e){ try { $stmt = $pdo->query("SELECT id, category_name, category_type FROM stream_categories ORDER BY category_type ASC, category_name ASC"); echo json_encode(['success' => true, 'data' => $stmt->fetchAll(PDO::FETCH_ASSOC)]); } catch(Exception $e2) { echo json_encode(['success' => true, 'data' => []]); } } exit; }
    if ($action === 'get_bouquets') { echo json_encode(['success' => true, 'data' => $pdo->query("SELECT id, bouquet_name FROM bouquets ORDER BY bouquet_name ASC")->fetchAll(PDO::FETCH_ASSOC)]); exit; }

    if ($action === 'get') {
        $dados = [];
        if ($type === 'clientes') { $dados = $pdo->query("SELECT id, username, password, exp_date, enabled, bouquet FROM users WHERE is_trial = 0 $filtro_clientes ORDER BY id DESC LIMIT 500")->fetchAll(PDO::FETCH_ASSOC); } 
        elseif ($type === 'testes') { $dados = $pdo->query("SELECT id, username, password, exp_date, enabled, bouquet FROM users WHERE is_trial = 1 $filtro_clientes ORDER BY id DESC LIMIT 500")->fetchAll(PDO::FETCH_ASSOC); } 
        elseif ($type === 'revendedores') { $dados = $pdo->query("SELECT id, username, password, status as enabled, credits, email FROM reg_users $filtro_revenda ORDER BY id DESC LIMIT 500")->fetchAll(PDO::FETCH_ASSOC); } 
        elseif ($type === 'bouquets') { if (!$is_admin) die(); $str_cats = $pdo->query("SELECT id, category_id FROM streams")->fetchAll(PDO::FETCH_KEY_PAIR); $ser_cats = $pdo->query("SELECT id, category_id FROM series")->fetchAll(PDO::FETCH_KEY_PAIR); $stmt = $pdo->query("SELECT id, bouquet_name, bouquet_channels, bouquet_series FROM bouquets ORDER BY id DESC"); while ($r = $stmt->fetch(PDO::FETCH_ASSOC)) { $strs = json_decode($r['bouquet_channels'], true) ?: []; $sers = json_decode($r['bouquet_series'], true) ?: []; $c_ids = []; foreach($strs as $sid) { if(isset($str_cats[$sid])) $c_ids[$str_cats[$sid]] = true; } foreach($sers as $sid) { if(isset($ser_cats[$sid])) $c_ids[$ser_cats[$sid]] = true; } $r['category_ids'] = array_keys($c_ids); $dados[] = $r; } }
        elseif ($type === 'canais') { if (!$is_admin) die(); $dados = $pdo->query("SELECT id, stream_display_name as name, stream_icon as logo, stream_source as url, category_id FROM streams WHERE type IN (1,3) ORDER BY id DESC LIMIT 1000")->fetchAll(PDO::FETCH_ASSOC); }
        elseif ($type === 'filmes') { if (!$is_admin) die(); $dados = $pdo->query("SELECT id, stream_display_name as name, stream_icon as logo, stream_source as url, category_id, target_container, movie_propeties as props FROM streams WHERE type = 2 ORDER BY id DESC LIMIT 1000")->fetchAll(PDO::FETCH_ASSOC); }
        elseif ($type === 'series') { if (!$is_admin) die(); $dados = $pdo->query("SELECT id, title as name, cover as logo, plot, category_id FROM series ORDER BY id DESC LIMIT 1000")->fetchAll(PDO::FETCH_ASSOC); }
        elseif ($type === 'episodios') { if (!$is_admin) die(); $sid = (int)($_GET['series_id'] ?? 0); $dados = $pdo->query("SELECT id, stream_display_name as name, stream_icon as logo, stream_source as url, target_container, movie_propeties as props FROM streams WHERE type = 5 AND series_no = $sid ORDER BY id ASC")->fetchAll(PDO::FETCH_ASSOC); }
        elseif ($type === 'seguranca') { if (!$is_admin) die(); $dados = $pdo->query("SELECT id, ip, notes, date, attempts_blocked FROM blocked_ips ORDER BY id DESC LIMIT 500")->fetchAll(PDO::FETCH_ASSOC); }
        echo json_encode(['success' => true, 'server_url' => (defined('SERVIDOR_URL') ? SERVIDOR_URL : ''), 'data' => $dados]); exit;
    }

    if ($action === 'save') {
        $id = $_POST['id'] ?? '';
        if ($type === 'categoria') { if (!$is_admin) die(); $cat_name = $_POST['cat_name'] ?? ''; $cat_type = $_POST['cat_type'] ?? 'live'; if (empty($id)) { $pdo->prepare("INSERT INTO stream_categories (category_name, category_type, parent_id, cat_order) VALUES (?, ?, 0, 0)")->execute([$cat_name, $cat_type]); } else { $pdo->prepare("UPDATE stream_categories SET category_name = ?, category_type = ? WHERE id = ?")->execute([$cat_name, $cat_type, $id]); } echo json_encode(['success' => true, 'msg' => 'Categoria salva!']); exit; }
        if ($type === 'bouquets') { $bouquet_name = $_POST['bouquet_name'] ?? ''; $cats = $_POST['categorias'] ?? []; $canais_filmes = []; $series_ids = []; if (!empty($cats)) { $in = implode(',', array_map('intval', $cats)); try { $canais_filmes = $pdo->query("SELECT id FROM streams WHERE category_id IN ($in)")->fetchAll(PDO::FETCH_COLUMN); $series_ids = $pdo->query("SELECT id FROM series WHERE category_id IN ($in)")->fetchAll(PDO::FETCH_COLUMN); } catch(Exception $e){} } $b_channels = json_encode(array_map('intval', $canais_filmes)); $b_series = json_encode(array_map('intval', $series_ids)); if (empty($id)) { $stmt = $pdo->prepare("INSERT INTO bouquets (bouquet_name, bouquet_channels, bouquet_series, bouquet_order) VALUES (?, ?, ?, 0)"); $stmt->execute([$bouquet_name, $b_channels, $b_series]); } else { $stmt = $pdo->prepare("UPDATE bouquets SET bouquet_name = ?, bouquet_channels = ?, bouquet_series = ? WHERE id = ?"); $stmt->execute([$bouquet_name, $b_channels, $b_series, $id]); } echo json_encode(['success' => true, 'msg' => 'Salvo com sucesso!']); exit; }
        if ($type === 'clientes' || $type === 'testes') { $username = $_POST['username'] ?? ''; $password = $_POST['password'] ?? ''; $is_trial = ($type === 'testes') ? 1 : 0; $vencimento_raw = $_POST['vencimento'] ?? ''; $exp_date = empty($vencimento_raw) ? null : strtotime($vencimento_raw . ' 23:59:59'); $bouquets = isset($_POST['bouquets']) ? json_encode(array_map('intval', $_POST['bouquets'])) : '[]'; if (empty($id)) { $stmt = $pdo->prepare("INSERT INTO users (username, password, exp_date, enabled, is_trial, created_at, member_id, bouquet) VALUES (?, ?, ?, 1, ?, ?, ?, ?)"); $stmt->execute([$username, $password, $exp_date, $is_trial, time(), $user_id, $bouquets]); } else { $stmt = $pdo->prepare("UPDATE users SET username = ?, password = ?, is_trial = ?, exp_date = ?, bouquet = ? WHERE id = ?"); $stmt->execute([$username, $password, $is_trial, $exp_date, $bouquets, $id]); } echo json_encode(['success' => true, 'msg' => 'Salvo com sucesso!']); exit; }
        if ($type === 'revendedores') { $username = $_POST['username'] ?? ''; $password = $_POST['password'] ?? ''; $email = $_POST['email'] ?? ''; $credits = $_POST['credits'] ?? 0; if (empty($id)) { $stmt = $pdo->prepare("INSERT INTO reg_users (username, password, email, credits, status, date_registered, member_group_id, owner_id) VALUES (?, ?, ?, ?, 1, ?, 2, ?)"); $stmt->execute([$username, $password, $email, $credits, time(), $user_id]); } else { $stmt = $pdo->prepare("UPDATE reg_users SET username = ?, password = ?, email = ?, credits = ? WHERE id = ?"); $stmt->execute([$username, $password, $email, $credits, $id]); } echo json_encode(['success' => true, 'msg' => 'Salvo com sucesso!']); exit; }

        if (in_array($type, ['canal', 'filme', 'serie', 'episodio'])) {
            if (!$is_admin) die();
            $nome = $_POST['c_nome'] ?? ''; $url = $_POST['c_url'] ?? ''; $cat = (int)($_POST['c_categoria'] ?? 0);
            $logo = $_POST['c_logo'] ?? ''; $plot = $_POST['c_plot'] ?? ''; $url_enc = json_encode([$url]);
            $cont = preg_match('/\.(mkv|avi|mov|mp4)$/i', $url, $m) ? $m[1] : 'mp4';
            if ($type === 'canal') { if(empty($id)) $pdo->prepare("INSERT INTO streams (type, category_id, stream_display_name, stream_source, stream_icon, target_container) VALUES (1,?,?,?,?, '[\"apple\"]')")->execute([$cat, $nome, $url_enc, $logo]); else $pdo->prepare("UPDATE streams SET category_id=?, stream_display_name=?, stream_source=?, stream_icon=? WHERE id=?")->execute([$cat, $nome, $url_enc, $logo, $id]); } 
            elseif ($type === 'filmes') { $prop = json_encode(['plot' => $plot, 'movie_image' => $logo]); if(empty($id)) $pdo->prepare("INSERT INTO streams (type, category_id, stream_display_name, stream_source, stream_icon, target_container, movie_propeties) VALUES (2,?,?,?,?,?,?)")->execute([$cat, $nome, $url_enc, $logo, $cont, $prop]); else $pdo->prepare("UPDATE streams SET category_id=?, stream_display_name=?, stream_source=?, stream_icon=?, target_container=?, movie_propeties=? WHERE id=?")->execute([$cat, $nome, $url_enc, $logo, $cont, $prop, $id]); } 
            elseif ($type === 'series') { if(empty($id)) $pdo->prepare("INSERT INTO series (title, category_id, cover, plot, releaseDate) VALUES (?,?,?,?,NOW())")->execute([$nome, $cat, $logo, $plot]); else $pdo->prepare("UPDATE series SET title=?, category_id=?, cover=?, plot=? WHERE id=?")->execute([$nome, $cat, $logo, $plot, $id]); } 
            elseif ($type === 'episodios') { $sid = (int)$_POST['c_series_id']; $s = (int)$_POST['c_season']; $e = (int)$_POST['c_episode']; $prop = json_encode(['season' => $s, 'episode' => $e, 'plot' => $plot]); if(empty($id)) $pdo->prepare("INSERT INTO streams (type, category_id, stream_display_name, stream_source, stream_icon, target_container, movie_propeties, series_no) VALUES (5,0,?,?,?,?,?,?)")->execute([$nome, $url_enc, $logo, $cont, $prop, $sid]); else $pdo->prepare("UPDATE streams SET stream_display_name=?, stream_source=?, stream_icon=?, target_container=?, movie_propeties=? WHERE id=?")->execute([$nome, $url_enc, $logo, $cont, $prop, $id]); }
            echo json_encode(['success' => true, 'msg' => 'Conteúdo salvo!']); exit;
        }
    }

    if ($action === 'renew') { $id = $_POST['id']; if (!verificarPosse($pdo, $id, $user_id, $is_admin, 'users')) die(); $stmt = $pdo->prepare("UPDATE users SET exp_date = ? WHERE id = ?"); $stmt->execute([strtotime("+".($_POST['meses'] ?? 1)." months"), $id]); echo json_encode(['success' => true, 'msg' => 'Renovado!']); exit; }
    if ($action === 'toggle') { $id = $_POST['id']; $tabela = ($type === 'revendedores') ? 'reg_users' : 'users'; if (!verificarPosse($pdo, $id, $user_id, $is_admin, $tabela)) die(); $col = ($type === 'revendedores') ? 'status' : 'enabled'; $stmt = $pdo->prepare("UPDATE $tabela SET $col = ? WHERE id = ?"); $stmt->execute([($_POST['status'] == 1 ? 0 : 1), $id]); echo json_encode(['success' => true]); exit; }
    if ($action === 'delete') {
        $id = $_POST['id'];
        if ($type === 'bouquets') { if (!$is_admin) die(); $pdo->prepare("DELETE FROM bouquets WHERE id = ?")->execute([$id]); } 
        elseif ($type === 'clientes' || $type === 'testes') { if (!verificarPosse($pdo, $id, $user_id, $is_admin, 'users')) die(); $pdo->prepare("DELETE FROM users WHERE id = ?")->execute([$id]); }
        elseif ($type === 'revendedores') { if (!verificarPosse($pdo, $id, $user_id, $is_admin, 'reg_users')) die(); $pdo->prepare("DELETE FROM reg_users WHERE id = ?")->execute([$id]); }
        elseif (in_array($type, ['canais', 'filmes', 'episodios'])) { if (!$is_admin) die(); $pdo->prepare("DELETE FROM streams WHERE id = ?")->execute([$id]); }
        elseif ($type === 'series') { if (!$is_admin) die(); $pdo->prepare("DELETE FROM series WHERE id = ?")->execute([$id]); $pdo->prepare("DELETE FROM streams WHERE series_no = ? AND type = 5")->execute([$id]); }
        elseif ($type === 'seguranca') { if (!$is_admin) die(); $pdo->prepare("DELETE FROM blocked_ips WHERE id = ?")->execute([$id]); }
        elseif ($type === 'categoria') { if (!$is_admin) die(); $pdo->prepare("DELETE FROM stream_categories WHERE id = ?")->execute([$id]); $pdo->prepare("DELETE FROM streams WHERE category_id = ?")->execute([$id]); $pdo->prepare("DELETE FROM series WHERE category_id = ?")->execute([$id]); }
        echo json_encode(['success' => true]); exit;
    }
} catch (PDOException $e) { echo json_encode(['success' => false, 'msg' => 'Erro BD: ' . $e->getMessage()]); }
?>
