<?php
// config.php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

$host = 'localhost'; 
$dbname = 'geanrober_xtreamui'; 
$user = 'geanrober_xtreamui'; 
$pass = 'Jean#909110';

define('SERVIDOR_URL', 'http://tvsbr.top/xtreamui');
define('TMDB_API_KEY', 'f99aa9ae1fe7619969cc7db0938c1ae5'); 

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die(json_encode(['success' => false, 'msg' => 'Erro de conexo com o banco.']));
}

// ==========================================
// SISTEMA DE SEGURANA E ANTI-FLOOD (WAF)
// ==========================================

// 1. Pega o IP real do usurio (Mesmo se estiver usando Cloudflare)
$ip = $_SERVER['REMOTE_ADDR'];
if (isset($_SERVER['HTTP_CF_CONNECTING_IP'])) {
    $ip = $_SERVER['HTTP_CF_CONNECTING_IP'];
} elseif (isset($_SERVER['HTTP_X_FORWARDED_FOR'])) {
    $ip = explode(',', $_SERVER['HTTP_X_FORWARDED_FOR'])[0];
}
$ip = trim($ip);

// 2. Verifica se o IP est na lista negra
$stmt_ban = $pdo->prepare("SELECT id, attempts_blocked FROM blocked_ips WHERE ip = ?");
$stmt_ban->execute([$ip]);
$is_banned = $stmt_ban->fetch(PDO::FETCH_ASSOC);

if ($is_banned) {
    // Se estiver banido, soma +1 tentativa bloqueada e encerra a conexo imediatamente
    $pdo->prepare("UPDATE blocked_ips SET attempts_blocked = attempts_blocked + 1 WHERE id = ?")->execute([$is_banned['id']]);
    http_response_code(403);
    die("Acesso Negado: Seu IP foi bloqueado pelo sistema de seguranca.");
}

// 3. Sistema Anti-Flood Automtico (Rate Limiting)
// Limite: 150 requisies a cada 10 segundos (Suficiente para Apps de Smart TV no serem bloqueados)
$limite_requisicoes = 150; 
$tempo_janela = 10; 

if (!isset($_SESSION['flood_time'])) {
    $_SESSION['flood_time'] = time();
    $_SESSION['flood_reqs'] = 1;
} else {
    if (time() - $_SESSION['flood_time'] < $tempo_janela) {
        $_SESSION['flood_reqs']++;
        if ($_SESSION['flood_reqs'] > $limite_requisicoes) {
            // BLOQUEIO AUTOMTICO: Insere o IP infrator no banco de dados
            try {
                $stmt_insert = $pdo->prepare("INSERT INTO blocked_ips (ip, notes, date, attempts_blocked) VALUES (?, 'Bloqueio Automatico WAF (Anti-Flood)', UNIX_TIMESTAMP(), 1)");
                $stmt_insert->execute([$ip]);
            } catch(Exception $e) {} // Ignora se j existir
            
            session_destroy();
            http_response_code(429);
            die("Voc foi bloqueado por excesso de requisicoes.");
        }
    } else {
        // Reseta o contador se passou os 10 segundos
        $_SESSION['flood_time'] = time();
        $_SESSION['flood_reqs'] = 1;
    }
}
?>
