<?php
// get.php
error_reporting(0);
require_once 'config.php';

$username = $_GET['username'] ?? '';
$password = $_GET['password'] ?? '';
$type = $_GET['type'] ?? '';
$stream_id = (int)($_GET['stream_id'] ?? 0);

// Valida Utilizador
$stmt = $pdo->prepare("SELECT * FROM users WHERE username = ? AND password = ? AND enabled = 1");
$stmt->execute([$username, $password]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$user || ($user['exp_date'] > 0 && $user['exp_date'] < time())) {
    http_response_code(401);
    die("Acesso Negado ou Expirado.");
}

// DAR O PLAY NO CONTEÚDO (Live, Movie ou Series)
if ($stream_id > 0) {
    $stmt = $pdo->prepare("SELECT stream_source FROM streams WHERE id = ?");
    $stmt->execute([$stream_id]);
    $stream = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($stream) {
        $source = $stream['stream_source'];
        
        // Limpa o formato JSON salvo no banco de dados do Xtream UI para extrair o link puro
        $decoded = json_decode($source, true);
        if (is_array($decoded) && isset($decoded[0])) {
            $link_real = $decoded[0];
        } else {
            // Se o JSON falhar, limpa na força bruta
            $link_real = str_replace(['["', '"]', '"', '\/'], ['', '', '', '/'], $source);
        }
        
        // Redireciona o aplicativo para o link real da operadora/P2P
        header("Location: " . trim($link_real));
        exit;
    }
}

// Se for baixar a lista M3U manualmente
if ($type === 'm3u' || $type === 'm3u_plus') {
    header('Content-Type: application/vnd.apple.mpegurl');
    header('Content-Disposition: attachment; filename="lista.m3u"');
    $server_url = defined('SERVIDOR_URL') ? SERVIDOR_URL : "http://" . $_SERVER['HTTP_HOST'];
    echo "#EXTM3U\n";
    $stmtC = $pdo->query("SELECT s.id, s.stream_display_name, s.stream_icon, c.category_name FROM streams s LEFT JOIN stream_categories c ON s.category_id = c.id WHERE s.type = 1");
    while ($row = $stmtC->fetch(PDO::FETCH_ASSOC)) {
        echo "#EXTINF:-1 tvg-id=\"\" tvg-name=\"{$row['stream_display_name']}\" tvg-logo=\"{$row['stream_icon']}\" group-title=\"{$row['category_name']}\",{$row['stream_display_name']}\n";
        echo "{$server_url}/live/{$username}/{$password}/{$row['id']}.ts\n";
    }
    exit;
}

http_response_code(404);
die("Conteúdo não encontrado.");
?>
