let abaAtual = 'dashboard'; let dadosAtuais = []; let todosBouquets = []; let todasCategorias = []; let serverUrl = ""; let logIntervalo = null; let currentSeriesId = 0; let currentSeriesName = '';
let cacheDados = {}; 

document.addEventListener('DOMContentLoaded', () => {
    document.getElementById('openSidebar').addEventListener('click', toggleMenu);
    document.getElementById('closeSidebar').addEventListener('click', toggleMenu);
    document.getElementById('sidebarOverlay').addEventListener('click', toggleMenu);
    document.getElementById('btn-recarregar').onclick = () => carregarDados(true);
    carregarBouquets(); carregarCategorias(); carregarDados();
});

const toggleMenu = () => { document.getElementById('sidebar').classList.toggle('-translate-x-full'); document.getElementById('sidebarOverlay').classList.toggle('hidden'); };
window.marcarTodos = (name, state) => document.querySelectorAll(`input[name="${name}"]`).forEach(cb => cb.checked = state);
function fecharModal(id) { document.getElementById(id).classList.add('hidden'); }

async function carregarBouquets() { try { const res = await fetch('api.php?action=get_bouquets'); const j = await res.json(); if(j.success) todosBouquets = j.data; } catch(e){} }
async function carregarCategorias() { try { const res = await fetch('api.php?action=get_categories'); const j = await res.json(); if(j.success) todasCategorias = j.data; } catch(e){} }

function mudarAba(nova) {
    abaAtual = nova; if(nova !== 'episodios') currentSeriesId = 0;
    document.querySelectorAll('.nav-btn').forEach(b => { b.classList.remove('bg-blue-600', 'text-white', 'shadow-md'); b.classList.add('text-gray-400', 'hover:bg-gray-800'); });
    const bAtivo = document.getElementById(`btn-${nova === 'episodios' ? 'series' : nova}`); if(bAtivo) { bAtivo.classList.remove('text-gray-400', 'hover:bg-gray-800'); bAtivo.classList.add('bg-blue-600', 'text-white', 'shadow-md'); }
    
    const t = { dashboard:'Dashboard', clientes:'Clientes', testes:'Testes', revendedores:'Revendedores', bouquets:'Bouquets', importador:'Importar', organizar:'Organizar', apagar:'Limpeza', canais:'Canais', filmes:'Filmes', series:'Séries', episodios:'Episódios', seguranca:'Firewall WAF' };
    document.getElementById('tituloPagina').innerText = t[nova] || 'Painel';
    if(window.innerWidth < 768) toggleMenu();
    
    ['grid-cards', 'tela-importador', 'tela-apagar', 'tela-organizar', 'topo-series'].forEach(id => { const e = document.getElementById(id); if(e) e.classList.add('hidden'); });
    ['btnNovoMobile', 'btnNovoDesktop', 'btn-recarregar', 'areaPesquisa', 'areaPesquisaMobile'].forEach(id => { const e = document.getElementById(id); if(e) e.classList.add('hidden'); });
    document.getElementById('inputPesquisa').value = ''; document.getElementById('inputPesquisaMobile').value = '';

    if (nova === 'importador') document.getElementById('tela-importador').classList.remove('hidden');
    else if (nova === 'apagar') { document.getElementById('tela-apagar').classList.remove('hidden'); renderizarCategoriasApagar(); }
    else if (nova === 'organizar') { document.getElementById('tela-organizar').classList.remove('hidden'); renderizarOrganizacaoCategorias(); }
    else { 
        document.getElementById('grid-cards').classList.remove('hidden'); document.getElementById('btn-recarregar').classList.remove('hidden'); 
        if (nova !== 'dashboard' && nova !== 'seguranca') { document.getElementById('btnNovoMobile').classList.remove('hidden'); document.getElementById('btnNovoDesktop').classList.remove('hidden'); }
        if (['canais', 'filmes', 'series', 'episodios', 'seguranca'].includes(nova)) { document.getElementById('areaPesquisa').classList.remove('hidden'); document.getElementById('areaPesquisaMobile').classList.remove('hidden'); }
        if (nova === 'episodios') { document.getElementById('topo-series').classList.remove('hidden'); document.getElementById('nome-serie-atual').innerText = currentSeriesName; }
        carregarDados(false); 
    }
}

// FIX 1: PESQUISA CORRIGIDA PARA NÃO QUEBRAR
function pesquisarGrid(isMobile = false) {
    const termo = document.getElementById(isMobile ? 'inputPesquisaMobile' : 'inputPesquisa').value.toLowerCase();
    document.querySelectorAll('#grid-cards > div').forEach(card => {
        const tituloEl = card.querySelector('h3');
        if (tituloEl) {
            const titulo = tituloEl.innerText.toLowerCase();
            card.style.display = titulo.includes(termo) ? 'flex' : 'none';
        }
    });
}

async function carregarDados(forcarRecarregamento = false) {
    const grid = document.getElementById('grid-cards'); if(!grid) return;
    let chaveCache = abaAtual === 'episodios' ? `episodios_${currentSeriesId}` : abaAtual;
    if (!forcarRecarregamento && cacheDados[chaveCache]) { renderizarCardsHtml(cacheDados[chaveCache]); return; }
    grid.innerHTML = `<div class="col-span-full text-center py-10 text-gray-500"><i class="fas fa-spinner fa-spin text-4xl text-blue-500 mb-3"></i><br>Carregando...</div>`;
    try {
        if (abaAtual === 'dashboard') {
            const res = await fetch(`api.php?action=dashboard_stats`); const j = await res.json();
            if (j.logout) return window.location.replace('login.php');
            cacheDados[chaveCache] = {isDash: true, d: j.data}; renderizarCardsHtml(cacheDados[chaveCache]); return;
        }
        let urlFetch = `api.php?action=get&type=${abaAtual}`; if(abaAtual === 'episodios') urlFetch += `&series_id=${currentSeriesId}`;
        const res = await fetch(urlFetch); const j = await res.json();
        if (j.logout) return window.location.replace('login.php');
        serverUrl = j.server_url; cacheDados[chaveCache] = {isDash: false, d: j.data}; renderizarCardsHtml(cacheDados[chaveCache]);
    } catch (e) { grid.innerHTML = `<div class="col-span-full text-center text-red-500">Erro de rede.</div>`; }
}

function renderizarCardsHtml(dadosSalvos) {
    const grid = document.getElementById('grid-cards'); let html = [];
    if (dadosSalvos.isDash) {
        const d = dadosSalvos.d;
        html.push(`
            <div class="col-span-full mb-1 border-b border-gray-800 pb-2">
                <h2 class="text-lg font-bold text-gray-300"><i class="fas fa-users text-blue-500 mr-2"></i>Gestão de Assinantes</h2>
            </div>
            <div class="bg-gradient-to-br from-[#1e293b] to-[#0f172a] p-5 rounded-xl border border-gray-700 shadow-lg text-center transform hover:scale-105 transition-transform">
                <span class="text-green-400 text-5xl font-black mb-1 block drop-shadow-[0_0_8px_rgba(74,222,128,0.5)]">${d.clientes.ativos}</span>
                <span class="text-gray-400 text-xs font-bold uppercase tracking-widest">Clientes Ativos</span>
            </div>
            <div class="bg-gradient-to-br from-[#1e293b] to-[#0f172a] p-5 rounded-xl border border-gray-700 shadow-lg text-center transform hover:scale-105 transition-transform">
                <span class="text-yellow-500 text-5xl font-black mb-1 block drop-shadow-[0_0_8px_rgba(234,179,8,0.5)]">${d.clientes.vencidos}</span>
                <span class="text-gray-400 text-xs font-bold uppercase tracking-widest">Contas Vencidas</span>
            </div>
            <div class="bg-gradient-to-br from-[#1e293b] to-[#0f172a] p-5 rounded-xl border border-gray-700 shadow-lg text-center transform hover:scale-105 transition-transform">
                <span class="text-red-500 text-5xl font-black mb-1 block drop-shadow-[0_0_8px_rgba(239,68,68,0.5)]">${d.clientes.bloqueados}</span>
                <span class="text-gray-400 text-xs font-bold uppercase tracking-widest">Bloqueados/Banidos</span>
            </div>
        `);

        if (d.is_admin && d.server) {
            const s = d.server;
            const corCpu = s.cpu > 80 ? 'bg-red-500' : (s.cpu > 50 ? 'bg-yellow-500' : 'bg-blue-500');
            const corRam = s.ram_p > 85 ? 'bg-red-500' : (s.ram_p > 60 ? 'bg-yellow-500' : 'bg-green-500');
            const corDisk = s.disk_p > 90 ? 'bg-red-500' : (s.disk_p > 70 ? 'bg-yellow-500' : 'bg-purple-500');

            html.push(`
                <div class="col-span-full mt-6 mb-1 border-b border-gray-800 pb-2 flex justify-between items-center">
                    <h2 class="text-lg font-bold text-gray-300"><i class="fas fa-server text-yellow-500 mr-2"></i>Status do Servidor</h2>
                    <span class="text-xs text-gray-500 bg-[#0f172a] px-2 py-1 rounded border border-gray-700">Uptime: ${s.up}</span>
                </div>
                <div class="col-span-full grid grid-cols-1 md:grid-cols-3 gap-4">
                    <div class="bg-[#1e293b] border border-gray-700 p-4 rounded-xl shadow">
                        <div class="flex justify-between items-center mb-2"><span class="text-gray-400 text-sm font-bold"><i class="fas fa-microchip mr-2"></i>CPU Load</span><span class="text-white font-bold">${s.cpu}%</span></div>
                        <div class="w-full bg-gray-900 rounded-full h-2"><div class="${corCpu} h-2 rounded-full" style="width: ${s.cpu}%"></div></div>
                    </div>
                    <div class="bg-[#1e293b] border border-gray-700 p-4 rounded-xl shadow">
                        <div class="flex justify-between items-center mb-2"><span class="text-gray-400 text-sm font-bold"><i class="fas fa-memory mr-2"></i>Memória RAM</span><span class="text-white font-bold">${s.ram_p}%</span></div>
                        <div class="w-full bg-gray-900 rounded-full h-2 mb-1"><div class="${corRam} h-2 rounded-full" style="width: ${s.ram_p}%"></div></div>
                        <p class="text-right text-[10px] text-gray-500">${s.ram_s} Usado</p>
                    </div>
                    <div class="bg-[#1e293b] border border-gray-700 p-4 rounded-xl shadow">
                        <div class="flex justify-between items-center mb-2"><span class="text-gray-400 text-sm font-bold"><i class="fas fa-hdd mr-2"></i>Armazenamento</span><span class="text-white font-bold">${s.disk_p}%</span></div>
                        <div class="w-full bg-gray-900 rounded-full h-2 mb-1"><div class="${corDisk} h-2 rounded-full" style="width: ${s.disk_p}%"></div></div>
                        <p class="text-right text-[10px] text-gray-500">${s.disk_s} Usado</p>
                    </div>
                </div>
            `);
        }

        html.push(`
            <div class="col-span-full mt-6 mb-1 border-b border-gray-800 pb-2">
                <h2 class="text-lg font-bold text-gray-300"><i class="fas fa-database text-purple-500 mr-2"></i>Acervo Disponível</h2>
            </div>
            <div class="bg-[#1e293b] p-4 rounded-xl border border-gray-700 flex items-center justify-between">
                <div class="flex items-center"><div class="w-12 h-12 rounded-full bg-blue-900 bg-opacity-30 flex items-center justify-center mr-4"><i class="fas fa-tv text-2xl text-blue-400"></i></div><div><p class="text-gray-400 text-xs font-bold uppercase">Canais de TV</p><p class="text-2xl font-black text-white">${d.conteudo.canais}</p></div></div>
            </div>
            <div class="bg-[#1e293b] p-4 rounded-xl border border-gray-700 flex items-center justify-between">
                <div class="flex items-center"><div class="w-12 h-12 rounded-full bg-green-900 bg-opacity-30 flex items-center justify-center mr-4"><i class="fas fa-film text-2xl text-green-400"></i></div><div><p class="text-gray-400 text-xs font-bold uppercase">Filmes & VOD</p><p class="text-2xl font-black text-white">${d.conteudo.filmes}</p></div></div>
            </div>
            <div class="bg-[#1e293b] p-4 rounded-xl border border-gray-700 flex items-center justify-between">
                <div class="flex items-center"><div class="w-12 h-12 rounded-full bg-purple-900 bg-opacity-30 flex items-center justify-center mr-4"><i class="fas fa-video text-2xl text-purple-400"></i></div><div><p class="text-gray-400 text-xs font-bold uppercase">Séries Diversas</p><p class="text-2xl font-black text-white">${d.conteudo.series}</p></div></div>
            </div>
        `);
        grid.innerHTML = html.join(''); return;
    }

    dadosAtuais = dadosSalvos.d;
    if (dadosAtuais.length === 0) { grid.innerHTML = `<div class="col-span-full text-center text-gray-500">Vazio.</div>`; return; }

    dadosAtuais.forEach(i => {
        if (abaAtual === 'seguranca') {
            let dB = new Date(i.date * 1000); let dF = `${String(dB.getDate()).padStart(2,'0')}/${String(dB.getMonth()+1).padStart(2,'0')} ${String(dB.getHours()).padStart(2,'0')}:${String(dB.getMinutes()).padStart(2,'0')}`;
            html.push(`<div class="bg-red-900 bg-opacity-20 border border-red-800 rounded-xl p-4 flex flex-col justify-between"><div><div class="flex justify-between items-start mb-2"><h3 class="text-lg font-bold text-red-400 truncate"><i class="fas fa-ban mr-2"></i>${i.ip}</h3><span class="bg-red-900 text-white text-[10px] px-2 py-1 rounded">BLOQUEADO</span></div><p class="text-xs text-gray-400 mb-2">Motivo: ${i.notes}</p><p class="text-xs text-gray-500 mb-2">Data: ${dF}</p><div class="flex justify-between text-sm mt-2 p-2 bg-[#0b1120] rounded border border-red-900"><span class="text-gray-400">Tentativas:</span><span class="font-bold text-yellow-500">${i.attempts_blocked}</span></div></div><div class="flex space-x-2 pt-4 mt-auto"><button onclick="excluirRegistro('seguranca',${i.id})" class="w-full bg-green-600 hover:bg-green-500 text-white py-2 rounded text-sm font-bold shadow"><i class="fas fa-unlock mr-2"></i> Desbloquear</button></div></div>`);
        }
        else if (['clientes', 'testes', 'revendedores', 'bouquets'].includes(abaAtual)) {
            if (abaAtual === 'bouquets') { html.push(`<div class="bg-[#1e293b] border border-gray-700 rounded-xl p-4 flex flex-col justify-between"><div><h3 class="text-lg font-bold text-gray-100 truncate"><i class="fas fa-layer-group text-purple-500 mr-2"></i>${i.bouquet_name}</h3></div><div class="flex space-x-2 pt-4 mt-auto border-t border-gray-800"><button onclick="abrirModal(${i.id})" class="flex-1 bg-gray-600 text-white py-2 rounded text-sm">Editar</button><button onclick="excluirRegistro('bouquets',${i.id})" class="flex-1 bg-red-600 text-white py-2 rounded text-sm">Excluir</button></div></div>`); return; }
            const isA = i.enabled == 1; const badge = isA ? `<span class="bg-green-900 bg-opacity-50 text-green-400 text-xs px-2 py-1 rounded">ON</span>` : `<span class="bg-red-900 bg-opacity-50 text-red-400 text-xs px-2 py-1 rounded">OFF</span>`;
            let dE = 'Ilimitado'; if (i.exp_date > 0) { const dO = new Date(i.exp_date * 1000); dE = `${String(dO.getDate()).padStart(2,'0')}/${String(dO.getMonth()+1).padStart(2,'0')}/${dO.getFullYear()}`; }
            html.push(`<div class="bg-[#1e293b] border border-gray-700 rounded-xl p-4 flex flex-col justify-between"><div><div class="flex justify-between items-start mb-2"><h3 class="text-lg font-bold text-gray-100 truncate">${i.username}</h3>${badge}</div><p class="text-xs text-gray-500 mb-2">Senha: ${i.password}</p><div class="flex justify-between text-sm mt-2 p-2 bg-[#0b1120] rounded"><span class="text-gray-400">${abaAtual==='revendedores'?'Créditos':'Vencimento'}</span><span class="font-bold text-white">${abaAtual==='revendedores'?(i.credits||0):dE}</span></div></div><div class="flex space-x-2 pt-4 mt-auto"><button onclick="abrirModal(${i.id})" class="flex-1 bg-gray-600 text-white py-2 rounded"><i class="fas fa-pen"></i></button>${abaAtual==='revendedores'?'':`<button onclick="abrirRenovar(${i.id})" class="flex-1 bg-green-600 text-white py-2 rounded"><i class="fas fa-sync-alt"></i></button><button onclick="abrirInfoModal(${i.id})" class="flex-1 bg-blue-600 text-white py-2 rounded"><i class="fas fa-eye"></i></button>`}<button onclick="alternarStatus(${i.id}, ${i.enabled})" class="flex-1 bg-yellow-600 text-white py-2 rounded"><i class="fas ${isA?'fa-lock':'fa-lock-open'}"></i></button><button onclick="excluirRegistro('${abaAtual}',${i.id})" class="flex-1 bg-red-600 text-white py-2 rounded"><i class="fas fa-trash"></i></button></div></div>`);
        } else {
            const img = i.logo ? `<img src="${i.logo}" class="w-full h-40 object-cover rounded-t-xl" loading="lazy">` : `<div class="w-full h-40 bg-gray-800 flex items-center justify-center rounded-t-xl"><i class="fas fa-image text-4xl text-gray-600"></i></div>`;
            let btnVerEps = abaAtual === 'series' ? `<button onclick="abrirEpisodios(${i.id}, '${i.name.replace(/'/g, "\\'")}')" class="w-full bg-blue-600 text-white py-2 rounded text-sm mb-2 font-bold"><i class="fas fa-list mr-2"></i>Ver Episódios</button>` : '';
            html.push(`<div class="bg-[#1e293b] border border-gray-700 rounded-xl shadow flex flex-col justify-between">${img}<div class="p-4"><h3 class="text-sm font-bold text-white truncate mb-2">${i.name}</h3>${btnVerEps}<div class="flex space-x-2"><button onclick="abrirModal(${i.id})" class="flex-1 bg-gray-600 text-white py-2 rounded text-sm"><i class="fas fa-pen"></i></button><button onclick="abrirMoverConteudo(${i.id}, '${i.name.replace(/'/g, "\\'")}')" class="flex-1 bg-blue-600 text-white py-2 rounded text-sm" title="Mover Categoria"><i class="fas fa-folder-open"></i></button><button onclick="excluirRegistro('${abaAtual}',${i.id})" class="flex-1 bg-red-600 text-white py-2 rounded text-sm"><i class="fas fa-trash"></i></button></div></div></div>`);
        }
    });
    grid.innerHTML = html.join(''); pesquisarGrid(); 
}

function abrirEpisodios(id, nome) { currentSeriesId = id; currentSeriesName = nome; mudarAba('episodios'); }

function abrirNovaCategoria(id = null, nome = '', tipo = 'live') {
    document.getElementById('formCategoria').reset();
    document.getElementById('cat_id').value = id || '';
    if (id) {
        document.getElementById('cat_name').value = nome;
        document.getElementById('cat_type').value = tipo;
        document.getElementById('tituloModalCat').innerText = 'Editar Categoria';
    } else {
        document.getElementById('tituloModalCat').innerText = 'Nova Categoria';
    }
    document.getElementById('modalCategoria').classList.remove('hidden');
}

async function salvarCategoria() {
    const fd = new FormData(document.getElementById('formCategoria'));
    try {
        const res = await fetch(`api.php?action=save&type=categoria`, { method: 'POST', body: fd });
        const json = await res.json();
        if (json.success) {
            fecharModal('modalCategoria');
            await carregarCategorias(); 
            renderizarOrganizacaoCategorias(); 
        } else { alert(json.msg); }
    } catch(e) { alert("Erro."); }
}

// ============================================
// FUNÇÕES RECONSTRUÍDAS QUE FALTAVAM
// ============================================

function abrirModal(id = null) {
    if (['canais', 'filmes', 'series', 'episodios'].includes(abaAtual)) {
        abrirModalConteudo(id);
    } else {
        abrirModalUsuario(id);
    }
}

function abrirModalUsuario(id) {
    document.getElementById('mainForm').reset();
    document.getElementById('formId').value = id || '';
    document.getElementById('modalTitle').innerText = id ? 'Editar' : 'Adicionar';
    
    // Mostra/esconde campos baseado na aba
    document.getElementById('divUserPass').classList.remove('hidden');
    document.getElementById('camposBouquet').classList.add('hidden');
    document.getElementById('camposRevenda').classList.add('hidden');
    document.getElementById('camposCliente').classList.remove('hidden');

    if (abaAtual === 'bouquets') {
        document.getElementById('divUserPass').classList.add('hidden');
        document.getElementById('camposCliente').classList.add('hidden');
        document.getElementById('camposBouquet').classList.remove('hidden');
        renderizarCategoriasBouquet();
    } else if (abaAtual === 'revendedores') {
        document.getElementById('camposCliente').classList.add('hidden');
        document.getElementById('camposRevenda').classList.remove('hidden');
    } else {
        renderizarBouquetsSelect();
    }

    if (id) {
        const item = dadosAtuais.find(i => i.id == id);
        if (item) {
            if (abaAtual !== 'bouquets') {
                document.getElementById('formUser').value = item.username || '';
                document.getElementById('formPass').value = item.password || '';
            }
            if (abaAtual === 'revendedores') {
                document.getElementById('formEmail').value = item.email || '';
                document.getElementById('formCredits').value = item.credits || '';
            } else if (abaAtual === 'bouquets') {
                document.getElementById('formBouquetName').value = item.bouquet_name || '';
                // Preencher categorias selecionadas se possível
            } else {
                if(item.exp_date > 0) {
                    const d = new Date(item.exp_date * 1000);
                    document.getElementById('formVencimento').value = d.toISOString().split('T')[0];
                }
            }
        }
    }
    document.getElementById('formModal').classList.remove('hidden');
}

function abrirModalConteudo(id) {
    document.getElementById('formConteudo').reset();
    document.getElementById('c_id').value = id || '';
    document.getElementById('c_series_id').value = abaAtual === 'episodios' ? currentSeriesId : '';
    document.getElementById('tituloModalConteudo').innerText = id ? 'Editar' : 'Adicionar';
    
    // Configura os campos baseados no tipo
    document.getElementById('divSinopse').classList.add('hidden');
    document.getElementById('divEpisodio').classList.add('hidden');
    document.getElementById('divUrl').classList.remove('hidden');
    document.getElementById('divCategoria').classList.remove('hidden');
    document.getElementById('btnTMDB').classList.add('hidden');
    
    if (abaAtual === 'filmes' || abaAtual === 'series') document.getElementById('divSinopse').classList.remove('hidden');
    if (abaAtual === 'filmes') document.getElementById('btnTMDB').classList.remove('hidden');
    if (abaAtual === 'series') {
        document.getElementById('divUrl').classList.add('hidden');
        document.getElementById('btnTMDB').classList.remove('hidden');
    }
    if (abaAtual === 'episodios') {
        document.getElementById('divCategoria').classList.add('hidden');
        document.getElementById('divEpisodio').classList.remove('hidden');
    }

    // Preenche categorias no select
    const selectCat = document.getElementById('c_categoria');
    selectCat.innerHTML = '';
    const tipoCat = abaAtual === 'canais' ? 'live' : (abaAtual === 'filmes' ? 'movie' : 'series');
    todasCategorias.filter(c => c.category_type === tipoCat).forEach(c => {
        selectCat.innerHTML += `<option value="${c.id}">${c.category_name}</option>`;
    });

    if (id) {
        const item = dadosAtuais.find(i => i.id == id);
        if (item) {
            document.getElementById('c_nome').value = item.name || '';
            document.getElementById('c_logo').value = item.logo || '';
            if(item.url) document.getElementById('c_url').value = item.url;
            if(item.category_id) selectCat.value = item.category_id;
            if(item.plot) document.getElementById('c_plot').value = item.plot;
            if(item.props) {
                try {
                    const props = JSON.parse(item.props);
                    if(props.season) document.getElementById('c_season').value = props.season;
                    if(props.episode) document.getElementById('c_episode').value = props.episode;
                } catch(e) {}
            }
        }
    }
    document.getElementById('modalConteudo').classList.remove('hidden');
}

async function salvarDados() {
    const fd = new FormData(document.getElementById('mainForm'));
    try {
        const res = await fetch(`api.php?action=save&type=${abaAtual}`, { method: 'POST', body: fd });
        const json = await res.json();
        if (json.success) {
            fecharModal('formModal');
            cacheDados = {}; carregarDados(true);
        } else { alert(json.msg); }
    } catch(e) { alert("Erro ao salvar."); }
}

async function salvarConteudo() {
    const fd = new FormData(document.getElementById('formConteudo'));
    try {
        const res = await fetch(`api.php?action=save&type=${abaAtual}`, { method: 'POST', body: fd });
        const json = await res.json();
        if (json.success) {
            fecharModal('modalConteudo');
            cacheDados = {}; carregarDados(true);
        } else { alert(json.msg); }
    } catch(e) { alert("Erro ao salvar."); }
}

async function excluirRegistro(tipo, id) {
    if(!confirm("Tem certeza que deseja excluir?")) return;
    try {
        const fd = new FormData(); fd.append('id', id);
        const res = await fetch(`api.php?action=delete&type=${tipo}`, { method: 'POST', body: fd });
        const json = await res.json();
        if (json.success) {
            if (tipo === 'categoria') {
                await carregarCategorias();
                renderizarOrganizacaoCategorias();
            } else {
                cacheDados = {}; carregarDados(true);
            }
        } else { alert(json.msg); }
    } catch(e) { alert("Erro ao excluir."); }
}

async function alternarStatus(id, atual) {
    try {
        const fd = new FormData(); fd.append('id', id); fd.append('status', atual == 1 ? 0 : 1);
        const res = await fetch(`api.php?action=toggle_status&type=${abaAtual}`, { method: 'POST', body: fd });
        const json = await res.json();
        if (json.success) { cacheDados = {}; carregarDados(true); }
    } catch(e) { alert("Erro."); }
}

function abrirInfoModal(id) {
    const item = dadosAtuais.find(i => i.id == id);
    if (!item) return;
    const txt = `Acesso:\nURL: ${serverUrl}\nUsuário: ${item.username}\nSenha: ${item.password}`;
    document.getElementById('textoInfo').value = txt;
    document.getElementById('infoModal').classList.remove('hidden');
}

function copiarInfo() {
    const txt = document.getElementById('textoInfo');
    txt.select(); document.execCommand('copy');
    alert("Copiado!");
}

function abrirRenovar(id) {
    document.getElementById('renewId').value = id;
    document.getElementById('renewMeses').value = 1;
    document.getElementById('renewModal').classList.remove('hidden');
}

async function confirmarRenovacao() {
    const id = document.getElementById('renewId').value;
    const meses = document.getElementById('renewMeses').value;
    try {
        const fd = new FormData(); fd.append('id', id); fd.append('meses', meses);
        const res = await fetch(`api.php?action=renew&type=${abaAtual}`, { method: 'POST', body: fd });
        const json = await res.json();
        if (json.success) {
            fecharModal('renewModal');
            cacheDados = {}; carregarDados(true);
            alert("Renovado com sucesso!");
        } else { alert(json.msg); }
    } catch(e) { alert("Erro."); }
}

function renderizarBouquetsSelect() {
    const list = document.getElementById('bouquetsList');
    if (!list) return;
    list.innerHTML = todosBouquets.map(b => `<label class="flex items-center space-x-2 text-sm text-gray-300"><input type="checkbox" name="bouquets[]" value="${b.id}" class="rounded bg-gray-700"> <span>${b.bouquet_name}</span></label>`).join('');
}

function renderizarCategoriasBouquet() {
    const list = document.getElementById('categoriasList');
    if (!list) return;
    list.innerHTML = todasCategorias.map(c => `<label class="flex items-center space-x-2 text-sm text-gray-300"><input type="checkbox" name="categorias[]" value="${c.id}" class="rounded bg-gray-700"> <span>[${c.category_type.toUpperCase()}] ${c.category_name}</span></label>`).join('');
}

// Lógica de Salvar Ordem nas Categorias
async function salvarOrdemCategorias() {
    const btn = event.target;
    btn.innerText = "Salvando..."; btn.disabled = true;
    
    let ordem = [];
    document.querySelectorAll('#sortable-live > div').forEach((e, i) => ordem.push({id: e.dataset.id, order: i}));
    document.querySelectorAll('#sortable-movie > div').forEach((e, i) => ordem.push({id: e.dataset.id, order: i}));
    document.querySelectorAll('#sortable-series > div').forEach((e, i) => ordem.push({id: e.dataset.id, order: i}));
    
    try {
        const fd = new FormData();
        fd.append('ordem', JSON.stringify(ordem));
        const res = await fetch(`api.php?action=salvar_ordem_categorias`, { method: 'POST', body: fd });
        const json = await res.json();
        if(json.success) alert("Ordem salva com sucesso!");
        else alert("Erro ao salvar ordem.");
    } catch(e) { alert("Erro de rede."); }
    
    btn.innerHTML = `<i class="fas fa-save mr-2"></i> Salvar Ordem`; btn.disabled = false;
}

// Funções do Mover Individual (que já existiam)
function abrirMoverConteudo(id, nome) {
    document.getElementById('move_id').value = id;
    document.getElementById('move_type').value = abaAtual;
    document.getElementById('move_nome').innerText = nome;
    
    const select = document.getElementById('move_nova_categoria');
    select.innerHTML = '';
    const tipoCat = abaAtual === 'canais' ? 'live' : (abaAtual === 'filmes' ? 'movie' : 'series');
    
    todasCategorias.filter(c => c.category_type === tipoCat).forEach(c => {
        select.innerHTML += `<option value="${c.id}" class="p-2 border-b border-gray-700 cursor-pointer hover:bg-gray-800">${c.category_name}</option>`;
    });
    
    document.getElementById('modalMover').classList.remove('hidden');
}

async function confirmarMover() {
    const id = document.getElementById('move_id').value;
    const cat = document.getElementById('move_nova_categoria').value;
    const tipo = document.getElementById('move_type').value;
    
    if(!cat) return alert('Selecione uma categoria.');
    
    try {
        const fd = new FormData(); fd.append('id', id); fd.append('nova_categoria', cat); fd.append('tipo_conteudo', tipo);
        const res = await fetch(`api.php?action=mover_conteudo`, { method: 'POST', body: fd });
        const json = await res.json();
        if(json.success) {
            fecharModal('modalMover');
            cacheDados = {}; carregarDados(true);
        } else alert(json.msg);
    } catch(e) { alert('Erro.'); }
}

function abrirMoverMassa() {
    const orig = document.getElementById('massa_origem');
    const dest = document.getElementById('massa_destino');
    orig.innerHTML = '<option value="">Selecione Origem...</option>'; 
    dest.innerHTML = '<option value="">Selecione Destino...</option>';
    
    todasCategorias.forEach(c => {
        const opt = `<option value="${c.id}">[${c.category_type.toUpperCase()}] ${c.category_name}</option>`;
        orig.innerHTML += opt; dest.innerHTML += opt;
    });
    document.getElementById('modalMoverMassa').classList.remove('hidden');
}

// FIX 2: RECONSTRUÍDA A FUNÇÃO E ADICIONADO ATRASO PARA O TOQUE NO CELULAR
function renderizarOrganizacaoCategorias() { 
    const lL=document.getElementById('sortable-live'); const lM=document.getElementById('sortable-movie'); const lS=document.getElementById('sortable-series'); 
    if(!lL)return; lL.innerHTML=''; lM.innerHTML=''; lS.innerHTML=''; 
    
    todasCategorias.forEach(c=>{ 
        const btnEdit = `<button onclick="abrirNovaCategoria(${c.id}, '${c.category_name.replace(/'/g, "\\'")}', '${c.category_type}')" class="text-blue-400 hover:text-white mr-3 p-2"><i class="fas fa-pen"></i></button>`;
        const btnDel = `<button onclick="excluirRegistro('categoria', ${c.id})" class="text-red-500 hover:text-white p-2"><i class="fas fa-trash"></i></button>`;
        const i=`<div class="bg-[#1e293b] border border-gray-600 p-3 rounded mb-2 flex items-center shadow" data-id="${c.id}"><i class="fas fa-grip-lines text-gray-500 mr-3 cursor-move text-xl p-1 touch-none"></i><span class="text-gray-200 font-medium truncate text-sm flex-1">${c.category_name}</span>${btnEdit}${btnDel}</div>`;
        
        if (c.category_type === 'live') lL.innerHTML += i;
        else if (c.category_type === 'movie') lM.innerHTML += i;
        else if (c.category_type === 'series') lS.innerHTML += i;
    });
    
    const opcoesSortable = {
        animation: 150,
        handle: '.cursor-move',
        delay: 250, 
        delayOnTouchOnly: true
    };
    
    new Sortable(lL, opcoesSortable);
    new Sortable(lM, opcoesSortable);
    new Sortable(lS, opcoesSortable);
}

// FIX 3: FUNÇÕES DE SELEÇÃO E TRANSFERÊNCIA DE ITENS EM MASSA
async function carregarItensCategoria() {
    const origemId = document.getElementById('massa_origem').value;
    const area = document.getElementById('area_itens_mover');
    const lista = document.getElementById('lista_itens_mover');
    if (!origemId || !area || !lista) return; 
    
    lista.innerHTML = '<div class="text-center text-gray-500 py-2"><i class="fas fa-spinner fa-spin"></i> Carregando...</div>';
    area.classList.remove('hidden');
    
    try {
        const cat = todasCategorias.find(c => c.id == origemId);
        const typeMap = { 'live': 'canais', 'movie': 'filmes', 'series': 'series' };
        const reqType = typeMap[cat.category_type];
        
        let dados = cacheDados[reqType] ? cacheDados[reqType].d : [];
        if (dados.length === 0) {
            const res = await fetch(`api.php?action=get&type=${reqType}`);
            const j = await res.json();
            dados = j.data;
        }
        
        const itensMover = dados.filter(i => i.category_id == origemId);
        
        if (itensMover.length === 0) {
            lista.innerHTML = '<div class="text-center text-gray-500 py-2">Categoria vazia.</div>';
            return;
        }
        
        lista.innerHTML = itensMover.map(i => `
            <label class="flex items-center space-x-3 p-2 bg-[#1e293b] rounded cursor-pointer border border-gray-700 hover:border-blue-500">
                <input type="checkbox" name="item_mover[]" value="${i.id}" class="w-4 h-4 rounded bg-gray-700 text-blue-500" checked>
                <span class="text-gray-200 truncate flex-1 font-medium">${i.name}</span>
            </label>
        `).join('');
        
    } catch (e) {
        lista.innerHTML = '<div class="text-center text-red-500 py-2">Erro ao carregar itens.</div>';
    }
}

function marcarTodosMover(state) {
    document.querySelectorAll('input[name="item_mover[]"]').forEach(cb => cb.checked = state);
}

async function confirmarMoverItens() {
    const origem = document.getElementById('massa_origem').value;
    const destino = document.getElementById('massa_destino').value;
    const selecionados = Array.from(document.querySelectorAll('input[name="item_mover[]"]:checked')).map(cb => cb.value);
    
    if (origem == destino) return alert("Origem e destino não podem ser iguais.");
    if (selecionados.length === 0) return alert("Selecione pelo menos um item.");
    if (!destino) return alert("Selecione um destino válido.");
    
    const btn = event.target; const textOrig = btn.innerText;
    btn.innerText = "Transferindo..."; btn.disabled = true;
    
    try {
        const fd = new FormData();
        fd.append('destino', destino);
        fd.append('itens', JSON.stringify(selecionados));
        fd.append('tipo_conteudo', todasCategorias.find(c => c.id == origem).category_type);

        const res = await fetch(`api.php?action=mover_itens_selecionados`, { method: 'POST', body: fd });
        const json = await res.json();
        
        if (json.success) {
            fecharModal('modalMoverMassa');
            cacheDados = {}; carregarDados(true); 
            alert(json.msg);
        } else alert(json.msg || "Erro ao mover.");
    } catch(e) { alert("Erro de comunicação."); }
    
    btn.innerText = textOrig; btn.disabled = false;
}
