<?php 
session_start(); 
if (!isset($_SESSION['logado']) || $_SESSION['logado'] !== true) { 
    header('Location: login.php'); 
    exit; 
} 
require_once 'config.php'; 
$meus_creditos = 0; 
$is_admin = isset($_SESSION['is_admin']) ? $_SESSION['is_admin'] : false; 
if (!$is_admin) { 
    try { 
        $stmt = $pdo->prepare("SELECT credits FROM reg_users WHERE id = ?"); 
        $stmt->execute([$_SESSION['user_id']]); 
        $meus_creditos = $stmt->fetchColumn() ?: 0; 
    } catch(Exception $e) {} 
} 
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Painel Gestor</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <script src="https://cdn.jsdelivr.net/npm/sortablejs@latest/Sortable.min.js"></script>
    <style>:root { color-scheme: dark; } html, body { background-color: #0f172a !important; color: #f8fafc; margin: 0; padding: 0; height: 100vh; overflow: hidden; } input:-webkit-autofill { -webkit-box-shadow: 0 0 0 30px #1e293b inset !important; -webkit-text-fill-color: white !important; } ::-webkit-scrollbar { width: 6px; } ::-webkit-scrollbar-track { background: #0f172a; } ::-webkit-scrollbar-thumb { background: #334155; border-radius: 4px; }</style>
</head>
<body class="flex antialiased">
    <aside id="sidebar" class="w-64 bg-[#0b1120] border-r border-gray-800 flex-shrink-0 absolute inset-y-0 left-0 transform -translate-x-full md:relative md:translate-x-0 transition-transform duration-300 z-40 shadow-2xl flex flex-col h-full">
        <div class="p-5 border-b border-gray-800 flex justify-between items-center bg-[#070b14]"><span class="text-xl font-bold text-blue-500"><i class="fas fa-bolt text-yellow-500 mr-2"></i>XTREAM UI</span><button id="closeSidebar" class="md:hidden text-gray-400 hover:text-white text-2xl"><i class="fas fa-times"></i></button></div>
        <?php if (!$is_admin): ?><div class="bg-[#1e293b] mx-4 mt-4 p-3 rounded-lg border border-gray-700 flex justify-between items-center shadow-inner"><span class="text-xs font-bold text-gray-400 uppercase tracking-wider">Meus Créditos</span><span class="text-lg font-black text-yellow-500"><i class="fas fa-coins mr-1"></i> <?= $meus_creditos ?></span></div><?php endif; ?>
        <nav class="p-4 space-y-2 flex-1 overflow-y-auto">
            <p class="text-xs font-bold text-gray-500 uppercase mb-2">Geral</p>
            <button onclick="mudarAba('dashboard')" id="btn-dashboard" class="nav-btn w-full text-left px-4 py-3 bg-blue-600 rounded text-white shadow"><i class="fas fa-chart-pie w-6 text-center"></i> Dashboard</button>
            <p class="text-xs font-bold text-gray-500 uppercase mb-2 mt-4">Gestão</p>
            <button onclick="mudarAba('clientes')" id="btn-clientes" class="nav-btn w-full text-left px-4 py-3 text-gray-400 hover:bg-gray-800 rounded"><i class="fas fa-user-check w-6 text-center"></i> Clientes</button>
            <button onclick="mudarAba('testes')" id="btn-testes" class="nav-btn w-full text-left px-4 py-3 text-gray-400 hover:bg-gray-800 rounded"><i class="fas fa-clock w-6 text-center"></i> Testes</button>
            <?php if ($is_admin): ?>
            <button onclick="mudarAba('revendedores')" id="btn-revendedores" class="nav-btn w-full text-left px-4 py-3 text-gray-400 hover:bg-gray-800 rounded"><i class="fas fa-user-tie w-6 text-center"></i> Revendas</button>
            <p class="text-xs font-bold text-gray-500 uppercase mb-2 mt-4">Conteúdos</p>
            <button onclick="mudarAba('canais')" id="btn-canais" class="nav-btn w-full text-left px-4 py-3 text-gray-400 hover:bg-gray-800 rounded"><i class="fas fa-tv w-6 text-center text-blue-400"></i> Canais</button>
            <button onclick="mudarAba('filmes')" id="btn-filmes" class="nav-btn w-full text-left px-4 py-3 text-gray-400 hover:bg-gray-800 rounded"><i class="fas fa-film w-6 text-center text-green-400"></i> Filmes</button>
            <button onclick="mudarAba('series')" id="btn-series" class="nav-btn w-full text-left px-4 py-3 text-gray-400 hover:bg-gray-800 rounded"><i class="fas fa-video w-6 text-center text-purple-400"></i> Séries</button>
            <p class="text-xs font-bold text-gray-500 uppercase mb-2 mt-4">Sistema</p>
            <button onclick="mudarAba('bouquets')" id="btn-bouquets" class="nav-btn w-full text-left px-4 py-3 text-gray-400 hover:bg-gray-800 rounded"><i class="fas fa-layer-group w-6 text-center"></i> Bouquets</button>
            <button onclick="mudarAba('importador')" id="btn-importador" class="nav-btn w-full text-left px-4 py-3 text-gray-400 hover:bg-gray-800 rounded"><i class="fas fa-download w-6 text-center text-green-400"></i> Importar M3U</button>
            <button onclick="mudarAba('organizar')" id="btn-organizar" class="nav-btn w-full text-left px-4 py-3 text-gray-400 hover:bg-gray-800 rounded"><i class="fas fa-sort w-6 text-center text-blue-300"></i> Organizar Categorias</button>
            <button onclick="mudarAba('apagar')" id="btn-apagar" class="nav-btn w-full text-left px-4 py-3 text-gray-400 hover:bg-gray-800 rounded"><i class="fas fa-trash w-6 text-center text-red-500"></i> Limpar / Apagar</button>
            <button onclick="mudarAba('seguranca')" id="btn-seguranca" class="nav-btn w-full text-left px-4 py-3 text-gray-400 hover:bg-gray-800 rounded"><i class="fas fa-shield-alt w-6 text-center text-yellow-500"></i> Firewall / IPs</button>
            <?php endif; ?>
        </nav>
        <div class="p-4 border-t border-gray-800"><a href="logout.php" class="flex items-center justify-center w-full px-4 py-3 bg-red-900 bg-opacity-20 text-red-500 hover:bg-red-600 hover:text-white rounded font-bold"><i class="fas fa-sign-out-alt mr-2"></i> Sair</a></div>
    </aside>

    <div id="sidebarOverlay" class="fixed inset-0 bg-black bg-opacity-80 z-30 hidden md:hidden"></div>
    <main class="flex-1 flex flex-col h-full relative z-10 w-full bg-[#0f172a]">
        <header class="bg-[#0b1120] p-4 border-b border-gray-800 flex items-center justify-between shadow-md h-16">
            <div class="flex items-center"><button id="openSidebar" class="text-gray-300 hover:text-white md:hidden mr-4"><i class="fas fa-bars text-2xl"></i></button><h1 id="tituloPagina" class="text-lg font-semibold text-gray-100">Dashboard</h1><button onclick="window.location.reload()" id="btn-recarregar" class="ml-4 text-blue-500 hover:text-blue-300 p-2 bg-blue-900 bg-opacity-20 rounded-full" title="Atualizar Painel"><i class="fas fa-sync-alt"></i></button></div>
            <div class="hidden md:flex items-center space-x-4">
                <div class="relative hidden" id="areaPesquisa">
                    <input type="text" id="inputPesquisa" onkeyup="pesquisarGrid()" placeholder="Pesquisar..." class="bg-[#1e293b] border border-gray-600 rounded-full px-4 py-1.5 text-sm text-white focus:outline-none focus:border-blue-500 pl-10 w-48 transition-all focus:w-64">
                    <i class="fas fa-search absolute left-3 top-2.5 text-gray-400 text-sm"></i>
                </div>
                <div class="text-right border-l border-gray-700 pl-4"><p class="text-sm font-bold text-gray-200"><?= htmlspecialchars($_SESSION['username'] ?? '') ?></p><?php if ($is_admin): ?><p class="text-xs text-blue-400">Administrador</p><?php else: ?><p class="text-xs font-bold text-yellow-500"><i class="fas fa-coins mr-1"></i> <?= $meus_creditos ?> Créditos</p><?php endif; ?></div>
                <button id="btnNovoDesktop" onclick="abrirModal()" class="bg-blue-600 hover:bg-blue-500 text-white px-4 py-2 rounded text-sm font-medium"><i class="fas fa-plus mr-2"></i> Novo</button>
            </div>
        </header>

        <div class="flex-1 overflow-y-auto p-4 md:p-6 relative">
            <div class="md:hidden mb-4 hidden" id="areaPesquisaMobile"><div class="relative"><input type="text" id="inputPesquisaMobile" onkeyup="pesquisarGrid(true)" placeholder="Pesquisar..." class="w-full bg-[#1e293b] border border-gray-600 rounded-lg px-4 py-3 text-white focus:outline-none focus:border-blue-500 pl-10"><i class="fas fa-search absolute left-3 top-4 text-gray-400"></i></div></div>
            <div id="topo-series" class="hidden mb-4"><button onclick="mudarAba('series')" class="bg-gray-700 text-white px-4 py-2 rounded text-sm"><i class="fas fa-arrow-left mr-2"></i>Séries</button> <span id="nome-serie-atual" class="text-lg text-purple-400 font-bold ml-4"></span></div>
            <div id="grid-cards" class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-4 pb-20"></div>
            
            <div id="tela-importador" class="hidden max-w-3xl mx-auto w-full pb-20"><div class="bg-[#1e293b] border border-gray-700 rounded p-5 shadow-2xl"><h2 class="text-xl font-bold text-green-400 mb-4"><i class="fas fa-download mr-2"></i>Importar M3U</h2><div class="flex gap-3 mb-6"><input type="url" id="m3u_url_input" placeholder="URL M3U" class="flex-1 bg-[#0f172a] border border-gray-600 rounded p-3 text-white"><button onclick="lerCategoriasM3U()" id="btn-ler-m3u" class="bg-blue-600 text-white px-6 py-3 rounded font-bold"><i class="fas fa-search mr-2"></i>Ler</button></div><div id="area-categorias-m3u" class="hidden border-t border-gray-700 pt-4 mt-2"><div class="flex justify-between items-center mb-3"><h3 class="font-bold text-gray-200">Selecionar:</h3><div><button onclick="marcarTodos('import_cat[]', true)" class="text-[11px] bg-gray-700 px-2 py-1 rounded text-white mr-1">Todas</button><button onclick="marcarTodos('import_cat[]', false)" class="text-[11px] bg-gray-800 px-2 py-1 rounded text-white border border-gray-600">Nenhuma</button></div></div><div id="lista-categorias-m3u" class="bg-[#0f172a] border border-gray-700 rounded p-3 h-64 overflow-y-auto mb-4"></div><button onclick="iniciarImportacaoM3U()" id="btn-iniciar-importacao" class="w-full bg-green-600 text-white py-4 rounded font-bold text-lg"><i class="fas fa-download mr-2"></i> Importar com TMDB</button><div id="area-log" class="hidden mt-6 bg-[#0b1120] border border-gray-700 rounded p-4"><div class="w-full bg-gray-800 rounded-full h-2.5 mb-2"><div id="barra-progresso" class="bg-blue-600 h-2.5 rounded-full" style="width: 0%"></div></div><p id="texto-log" class="text-xs text-gray-400 font-mono mt-2">Preparando...</p></div></div></div></div>
            
            <div id="tela-organizar" class="hidden max-w-6xl mx-auto w-full pb-20">
                <div class="bg-[#1e293b] border border-gray-700 rounded p-5 shadow-2xl mb-6 flex flex-col md:flex-row justify-between items-start md:items-center gap-4">
                    <div><h2 class="text-xl font-bold text-blue-400"><i class="fas fa-folder-open mr-2"></i>Organizar & Categorias</h2><p class="text-sm text-gray-400">Crie, edite e arraste para organizar.</p></div>
                    <div class="flex flex-wrap gap-2 w-full md:w-auto">
                        <button onclick="abrirNovaCategoria()" class="flex-1 md:flex-none bg-green-600 hover:bg-green-500 text-white px-4 py-2 rounded font-bold shadow"><i class="fas fa-plus mr-2"></i>Nova Categoria</button>
                        <button onclick="abrirMoverMassa()" class="flex-1 md:flex-none bg-blue-600 hover:bg-blue-500 text-white px-4 py-2 rounded font-bold shadow"><i class="fas fa-exchange-alt mr-2"></i>Mover em Massa</button>
                        <button onclick="salvarOrdemCategorias()" class="w-full md:w-auto bg-gray-600 hover:bg-gray-500 text-white px-4 py-2 rounded font-bold shadow"><i class="fas fa-save mr-2"></i> Salvar Ordem</button>
                    </div>
                </div>
                <div class="grid grid-cols-1 md:grid-cols-3 gap-4"><div class="bg-[#0f172a] border border-gray-700 rounded p-3"><h3 class="font-bold text-blue-400 mb-3 border-b border-gray-700 pb-2">Canais</h3><div id="sortable-live" class="space-y-2 min-h-[100px]"></div></div><div class="bg-[#0f172a] border border-gray-700 rounded p-3"><h3 class="font-bold text-green-400 mb-3 border-b border-gray-700 pb-2">Filmes</h3><div id="sortable-movie" class="space-y-2 min-h-[100px]"></div></div><div class="bg-[#0f172a] border border-gray-700 rounded p-3"><h3 class="font-bold text-purple-400 mb-3 border-b border-gray-700 pb-2">Séries</h3><div id="sortable-series" class="space-y-2 min-h-[100px]"></div></div></div>
            </div>
            
            <div id="tela-apagar" class="hidden max-w-3xl mx-auto w-full pb-20">
                <div class="bg-[#1e293b] border border-red-900 rounded p-5 shadow-2xl">
                    <h2 class="text-xl font-bold text-red-500 mb-4"><i class="fas fa-trash-alt mr-2"></i>Apagar do Banco</h2>
                    <div class="bg-yellow-900 bg-opacity-20 border border-yellow-800 rounded-lg p-5 text-center mb-8"><h3 class="text-yellow-500 font-bold text-lg mb-2"><i class="fas fa-clone mr-2"></i>Limpar Duplicados</h3><p class="text-sm text-gray-400 mb-4">Isto irá procurar e apagar conteúdos com o mesmo nome e categoria, mantendo apenas um de cada.</p><button onclick="apagarDuplicados()" id="btn-apagar-duplicados" class="w-full bg-yellow-600 hover:bg-yellow-500 text-white py-3 rounded-lg font-bold shadow-lg transition-colors"><i class="fas fa-broom mr-2"></i> LIMPAR DUPLICADOS</button></div>
                    <div id="lista-categorias-apagar" class="bg-[#0f172a] border border-gray-700 rounded p-3 h-[400px] overflow-y-auto mb-4"></div><button onclick="apagarCategoriasSelecionadas()" id="btn-apagar-selecionados" class="w-full bg-red-600 text-white py-4 rounded font-bold text-lg mb-8"><i class="fas fa-trash-alt mr-2"></i> Apagar Categorias Selecionadas</button><hr class="border-gray-700 mb-8"><div class="bg-red-900 bg-opacity-20 border border-red-800 rounded p-5 text-center"><button onclick="apagarTodoConteudo()" id="btn-apagar-tudo" class="w-full bg-red-800 text-white py-3 rounded font-bold"><i class="fas fa-skull-crossbones mr-2"></i> APAGAR TUDO (WIPE)</button></div>
                </div>
            </div>
        </div>
        <button id="btnNovoMobile" onclick="abrirModal()" class="hidden fixed bottom-6 right-6 bg-blue-600 text-white w-14 h-14 rounded-full flex items-center justify-center text-2xl z-20 md:hidden"><i class="fas fa-plus"></i></button>
    </main>

    <div id="formModal" class="fixed inset-0 z-50 hidden bg-black bg-opacity-80 flex items-center justify-center p-4"><div class="bg-[#1e293b] border border-gray-700 rounded-2xl w-full max-w-md shadow-2xl flex flex-col max-h-[90vh]"><div class="flex justify-between items-center p-5 border-b border-gray-700 bg-[#0f172a] rounded-t-2xl"><h2 id="modalTitle" class="text-xl font-bold text-blue-400">Adicionar</h2><button onclick="fecharModal('formModal')" class="text-gray-400 hover:text-white text-2xl"><i class="fas fa-times"></i></button></div><div class="p-5 overflow-y-auto"><form id="mainForm" class="space-y-4"><input type="hidden" id="formId" name="id"><div id="divUserPass" class="grid grid-cols-2 gap-4"><div><label class="text-sm text-gray-400 mb-1 block">Usuário</label><input type="text" id="formUser" name="username" class="w-full bg-[#0f172a] border border-gray-600 rounded p-3 text-white"></div><div><label class="text-sm text-gray-400 mb-1 block">Senha</label><input type="text" id="formPass" name="password" class="w-full bg-[#0f172a] border border-gray-600 rounded p-3 text-white"></div></div><div id="camposBouquet" class="hidden space-y-4"><div><label class="text-sm text-gray-400 mb-1 block">Nome do Pacote</label><input type="text" id="formBouquetName" name="bouquet_name" class="w-full bg-[#0f172a] border border-gray-600 rounded p-3 text-white"></div><div><label class="text-sm text-gray-400 mb-2 block">Categorias</label><div id="categoriasList" class="bg-[#0f172a] border border-gray-600 rounded p-3 max-h-48 overflow-y-auto space-y-2"></div></div></div><div id="camposRevenda" class="hidden space-y-4"><div><label class="text-sm text-gray-400 mb-1 block">E-mail</label><input type="email" id="formEmail" name="email" class="w-full bg-[#0f172a] border border-gray-600 rounded p-3 text-white"></div><div><label class="text-sm text-gray-400 mb-1 block">Créditos</label><input type="number" id="formCredits" name="credits" class="w-full bg-[#0f172a] border border-gray-600 rounded p-3 text-white"></div></div><div id="camposCliente" class="space-y-4"><div><label class="text-sm text-gray-400 mb-1 block">Vencimento</label><input type="date" id="formVencimento" name="vencimento" class="w-full bg-[#0f172a] border border-gray-600 rounded p-3 text-white [color-scheme:dark]"></div><div><label class="text-sm text-gray-400 mb-2 block">Pacotes</label><div id="bouquetsList" class="bg-[#0f172a] border border-gray-600 rounded p-3 max-h-32 overflow-y-auto space-y-2"></div></div></div></form></div><div class="p-5 border-t border-gray-700 flex space-x-3 bg-[#0f172a] rounded-b-2xl"><button onclick="fecharModal('formModal')" class="flex-1 bg-gray-700 text-white py-3 rounded font-medium">Cancelar</button><button onclick="salvarDados()" class="flex-1 bg-blue-600 text-white py-3 rounded font-medium">Salvar</button></div></div></div>
    
    <div id="modalConteudo" class="fixed inset-0 z-50 hidden bg-black bg-opacity-80 flex items-center justify-center p-4"><div class="bg-[#1e293b] border border-gray-700 rounded-2xl w-full max-w-lg shadow-2xl flex flex-col max-h-[90vh]"><div class="flex justify-between items-center p-5 border-b border-gray-700 bg-[#0f172a] rounded-t-2xl"><h2 id="tituloModalConteudo" class="text-xl font-bold text-green-400">Adicionar</h2><button onclick="fecharModal('modalConteudo')" class="text-gray-400 hover:text-white text-2xl"><i class="fas fa-times"></i></button></div><div class="p-5 overflow-y-auto space-y-4"><form id="formConteudo"><input type="hidden" id="c_id" name="id"> <input type="hidden" id="c_series_id" name="c_series_id"><div class="mb-4"><label class="text-sm text-gray-400 mb-1 block">Título</label><div class="flex gap-2"><input type="text" id="c_nome" name="c_nome" class="flex-1 bg-[#0f172a] border border-gray-600 rounded p-3 text-white" placeholder="Nome"><button type="button" id="btnTMDB" onclick="abrirPesquisaTMDB()" class="bg-blue-600 text-white px-4 rounded font-bold hidden"><i class="fas fa-search mr-2"></i>TMDB</button></div></div><div id="divUrl" class="mb-4"><label class="text-sm text-gray-400 mb-1 block">Link (URL)</label><input type="text" id="c_url" name="c_url" class="w-full bg-[#0f172a] border border-gray-600 rounded p-3 text-white"></div><div id="divCategoria" class="mb-4"><label class="text-sm text-gray-400 mb-1 block">Categoria</label><select id="c_categoria" name="c_categoria" class="w-full bg-[#0f172a] border border-gray-600 rounded p-3 text-white"></select></div><div id="divEpisodio" class="grid grid-cols-2 gap-4 mb-4 hidden"><div><label class="text-sm text-gray-400 mb-1 block">Temporada</label><input type="number" id="c_season" name="c_season" class="w-full bg-[#0f172a] border border-gray-600 rounded p-3 text-white"></div><div><label class="text-sm text-gray-400 mb-1 block">Episódio</label><input type="number" id="c_episode" name="c_episode" class="w-full bg-[#0f172a] border border-gray-600 rounded p-3 text-white"></div></div><div class="mb-4"><label class="text-sm text-gray-400 mb-1 block">Capa / Logo</label><input type="text" id="c_logo" name="c_logo" class="w-full bg-[#0f172a] border border-gray-600 rounded p-3 text-white"></div><div id="divSinopse" class="mb-4 hidden"><label class="text-sm text-gray-400 mb-1 block">Sinopse</label><textarea id="c_plot" name="c_plot" class="w-full bg-[#0f172a] border border-gray-600 rounded p-3 text-white h-24"></textarea></div></form></div><div class="p-5 border-t border-gray-700 flex space-x-3 bg-[#0f172a] rounded-b-2xl"><button onclick="fecharModal('modalConteudo')" class="flex-1 bg-gray-700 text-white py-3 rounded font-medium">Cancelar</button><button onclick="salvarConteudo()" class="flex-1 bg-green-600 text-white py-3 rounded font-medium">Salvar</button></div></div></div>
    
    <div id="modalCategoria" class="fixed inset-0 z-50 hidden bg-black bg-opacity-80 flex items-center justify-center p-4">
        <div class="bg-[#1e293b] border border-gray-700 rounded-2xl w-full max-w-sm shadow-2xl flex flex-col">
            <div class="flex justify-between items-center p-5 border-b border-gray-700 bg-[#0f172a] rounded-t-2xl"><h2 id="tituloModalCat" class="text-xl font-bold text-green-400">Nova Categoria</h2><button onclick="fecharModal('modalCategoria')" class="text-gray-400 hover:text-white text-2xl"><i class="fas fa-times"></i></button></div>
            <div class="p-5">
                <form id="formCategoria">
                    <input type="hidden" id="cat_id" name="id">
                    <div class="mb-4"><label class="text-sm text-gray-400 mb-1 block">Nome da Categoria</label><input type="text" id="cat_name" name="cat_name" class="w-full bg-[#0f172a] border border-gray-600 rounded p-3 text-white"></div>
                    <div class="mb-4"><label class="text-sm text-gray-400 mb-1 block">Tipo de Conteúdo</label><select id="cat_type" name="cat_type" class="w-full bg-[#0f172a] border border-gray-600 rounded p-3 text-white"><option value="live">Canais ao Vivo</option><option value="movie">Filmes</option><option value="series">Séries</option></select></div>
                </form>
            </div>
            <div class="p-5 border-t border-gray-700 flex space-x-3 bg-[#0f172a] rounded-b-2xl"><button onclick="fecharModal('modalCategoria')" class="flex-1 bg-gray-700 text-white py-3 rounded font-medium">Cancelar</button><button onclick="salvarCategoria()" class="flex-1 bg-green-600 text-white py-3 rounded font-medium">Salvar</button></div>
        </div>
    </div>

    <div id="modalMover" class="fixed inset-0 z-50 hidden bg-black bg-opacity-80 flex items-center justify-center p-4"><div class="bg-[#1e293b] border border-gray-700 rounded-2xl w-full max-w-sm shadow-2xl flex flex-col"><div class="flex justify-between items-center p-5 border-b border-gray-700 bg-[#0f172a] rounded-t-2xl"><h2 class="text-xl font-bold text-blue-400">Mover Pasta</h2><button onclick="fecharModal('modalMover')" class="text-gray-400 hover:text-white text-2xl"><i class="fas fa-times"></i></button></div><div class="p-5"><input type="hidden" id="move_id"> <input type="hidden" id="move_type"><p id="move_nome" class="text-gray-300 font-bold mb-4 text-center"></p><label class="text-sm text-gray-400 mb-2 block">Escolha o Novo Destino:</label><select id="move_nova_categoria" class="w-full bg-[#0f172a] border border-gray-600 rounded p-3 text-white h-48" size="8"></select></div><div class="p-5 border-t border-gray-700 flex space-x-3 bg-[#0f172a] rounded-b-2xl"><button onclick="fecharModal('modalMover')" class="flex-1 bg-gray-700 text-white py-3 rounded font-medium">Cancelar</button><button onclick="confirmarMover()" class="flex-1 bg-blue-600 text-white py-3 rounded font-medium">Transferir</button></div></div></div>
    
    <div id="modalMoverMassa" class="fixed inset-0 z-50 hidden bg-black bg-opacity-80 flex items-center justify-center p-4">
        <div class="bg-[#1e293b] border border-gray-700 rounded-2xl w-full max-w-md shadow-2xl flex flex-col max-h-[90vh]">
            <div class="flex justify-between items-center p-5 border-b border-gray-700 bg-[#0f172a] rounded-t-2xl">
                <h2 class="text-xl font-bold text-blue-400">Transferência de Conteúdos</h2>
                <button onclick="fecharModal('modalMoverMassa')" class="text-gray-400 hover:text-white text-2xl"><i class="fas fa-times"></i></button>
            </div>
            <div class="p-5 overflow-y-auto space-y-4">
                <div>
                    <label class="text-sm font-bold text-red-400 mb-1 block">Tirar Daqui (Origem):</label>
                    <select id="massa_origem" onchange="carregarItensCategoria()" class="w-full bg-[#0f172a] border border-gray-600 rounded p-3 text-white"></select>
                </div>
                
                <div id="area_itens_mover" class="hidden">
                    <div class="flex justify-between items-center mb-2">
                        <span class="text-sm text-gray-400 font-bold">Quais deseja mover?</span>
                        <div>
                            <button onclick="marcarTodosMover(true)" class="text-[11px] bg-gray-700 px-2 py-1 rounded text-white mr-1">Todos</button>
                            <button onclick="marcarTodosMover(false)" class="text-[11px] bg-gray-800 px-2 py-1 rounded text-white border border-gray-600">Nenhum</button>
                        </div>
                    </div>
                    <div id="lista_itens_mover" class="bg-[#0f172a] border border-gray-600 rounded p-3 max-h-48 overflow-y-auto text-sm space-y-2">
                        </div>
                </div>

                <div class="text-center text-2xl text-gray-500"><i class="fas fa-arrow-down"></i></div>
                
                <div>
                    <label class="text-sm font-bold text-green-400 mb-1 block">Colocar Aqui (Destino):</label>
                    <select id="massa_destino" class="w-full bg-[#0f172a] border border-gray-600 rounded p-3 text-white"></select>
                </div>
            </div>
            <div class="p-5 border-t border-gray-700 flex space-x-3 bg-[#0f172a] rounded-b-2xl">
                <button onclick="fecharModal('modalMoverMassa')" class="flex-1 bg-gray-700 text-white py-3 rounded font-medium">Cancelar</button>
                <button onclick="confirmarMoverItens()" class="flex-1 bg-blue-600 text-white py-3 rounded font-medium">Transferir Selecionados</button>
            </div>
        </div>
    </div>
    
    <div id="modalTMDB" class="fixed inset-0 z-50 hidden bg-black bg-opacity-80 flex items-center justify-center p-4"><div class="bg-[#1e293b] border border-gray-700 rounded-2xl w-full max-w-2xl shadow-2xl flex flex-col max-h-[90vh]"><div class="flex justify-between items-center p-5 border-b border-gray-700 bg-[#0f172a] rounded-t-2xl"><h2 class="text-xl font-bold text-blue-400">Resultados TMDB</h2><button onclick="fecharModal('modalTMDB')" class="text-gray-400 hover:text-white text-2xl"><i class="fas fa-times"></i></button></div><div class="p-5 overflow-y-auto"><div id="grid-tmdb" class="grid grid-cols-2 md:grid-cols-4 gap-4"></div></div></div></div>
    <div id="infoModal" class="fixed inset-0 z-50 hidden bg-black bg-opacity-80 flex items-center justify-center p-4"><div class="bg-[#1e293b] border border-gray-700 rounded-2xl w-full max-w-md"><div class="flex justify-between items-center p-5 border-b border-gray-700 bg-[#0f172a] rounded-t-2xl"><h2 class="text-lg font-bold text-white">Acesso</h2><button onclick="fecharModal('infoModal')" class="text-gray-400 hover:text-white text-2xl"><i class="fas fa-times"></i></button></div><div class="p-5"><textarea id="textoInfo" class="w-full bg-[#0f172a] border border-gray-600 text-sm text-gray-300 rounded-lg p-3 h-48 focus:outline-none" readonly></textarea><div class="flex space-x-3 mt-4"><button onclick="copiarInfo()" class="flex-1 bg-gray-700 text-white py-3 rounded-lg"><i class="fas fa-copy mr-2"></i> Copiar</button></div></div></div></div>
    <div id="renewModal" class="fixed inset-0 z-50 hidden bg-black bg-opacity-80 flex items-center justify-center p-4"><div class="bg-[#1e293b] border border-gray-700 rounded-2xl w-full max-w-sm"><div class="p-5 border-b border-gray-700 bg-[#0f172a] rounded-t-2xl"><h2 class="text-lg font-bold text-white">Renovar</h2></div><div class="p-5"><input type="hidden" id="renewId"><label class="block text-sm text-gray-400 mb-1">Meses:</label><input type="number" id="renewMeses" value="1" min="1" class="w-full bg-[#0f172a] border border-gray-600 rounded-lg p-3 text-white mb-4"><div class="flex space-x-3"><button onclick="fecharModal('renewModal')" class="flex-1 bg-gray-700 text-white py-3 rounded-lg">Cancelar</button><button onclick="confirmarRenovacao()" class="flex-1 bg-green-600 text-white py-3 rounded-lg font-bold">Renovar</button></div></div></div></div>

    <script src="app.js"></script>
</body>
</html>
