<?php
// firewall.php
$ip = $_SERVER['HTTP_CF_CONNECTING_IP'] ?? $_SERVER['HTTP_X_FORWARDED_FOR'] ?? $_SERVER['REMOTE_ADDR'] ?? '0.0.0.0';
$ua = $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown';

// 1. VERIFICA SE O IP ESTÁ BLOQUEADO
$stmtIp = $pdo->prepare("SELECT id FROM blocked_ips WHERE ip = ?");
$stmtIp->execute([$ip]);
if ($stmtIp->fetch()) {
    $pdo->exec("UPDATE blocked_ips SET attempts_blocked = attempts_blocked + 1 WHERE ip = '$ip'");
    http_response_code(403);
    die("Acesso Negado (Firewall)");
}

// 2. VERIFICA SE O APP/USER-AGENT ESTÁ BLOQUEADO
$stmtUa = $pdo->prepare("SELECT id FROM blocked_user_agents WHERE ? LIKE CONCAT('%', user_agent, '%')");
$stmtUa->execute([$ua]);
if ($stmtUa->fetch()) {
    $pdo->exec("UPDATE blocked_user_agents SET attempts_blocked = attempts_blocked + 1 WHERE user_agent = '$ua' OR '$ua' LIKE CONCAT('%', user_agent, '%') LIMIT 1");
    http_response_code(403);
    die("Aplicativo nao autorizado.");
}

// 3. AUTO-BLOQUEIO ANTI-DDOS (RATE LIMITING RÁPIDO EM DISCO)
$temp_dir = sys_get_temp_dir() . '/xtream_firewall';
if (!is_dir($temp_dir)) @mkdir($temp_dir);
$req_file = $temp_dir . '/' . md5($ip) . '.txt';
$now = time();
$requests = 1;

if (file_exists($req_file)) {
    $data = explode('|', @file_get_contents($req_file));
    if (isset($data[0]) && ($now - $data[0]) < 5) { 
        // Se acessou nos últimos 5 segundos, soma a contagem
        $requests = $data[1] + 1;
        if ($requests > 40) { 
            // MAIS DE 40 ACESSOS EM 5 SEGUNDOS = ATAQUE DETECTADO -> BLOQUEIA AUTOMATICAMENTE!
            $stmtBlock = $pdo->prepare("INSERT INTO blocked_ips (ip, notes, date, attempts_blocked) VALUES (?, 'Auto-Block: Ataque DDoS/Spam Detectado', ?, 1)");
            $stmtBlock->execute([$ip, $now]);
            http_response_code(403);
            die("IP Bloqueado por excesso de requisicoes.");
        }
    } else {
        $requests = 1; // Reseta a contagem após 5 segundos de paz
    }
}
@file_put_contents($req_file, "$now|$requests");
?>
