<?php
// player_api.php
error_reporting(0);
ini_set('display_errors', 0);
header('Content-Type: application/json');
require_once 'config.php';

$username = $_GET['username'] ?? '';
$password = $_GET['password'] ?? '';
$action = $_GET['action'] ?? '';

// 1. AUTENTICAÇÃO
$stmt = $pdo->prepare("SELECT * FROM users WHERE username = ? AND password = ? AND enabled = 1");
$stmt->execute([$username, $password]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$user) { die(json_encode(["user_info" => ["auth" => 0]])); }
if ($user['exp_date'] > 0 && $user['exp_date'] < time()) { die(json_encode(["user_info" => ["auth" => 0, "status" => "Expired"]])); }

// 2. CONFIGURAÇÃO DE HOST E PORTA PARA O APP
$base_url = defined('SERVIDOR_URL') ? SERVIDOR_URL : "http://" . $_SERVER['HTTP_HOST'];
$parsed_url = parse_url($base_url);
$protocol = $parsed_url['scheme'] ?? 'http';
$host = $parsed_url['host'] ?? $_SERVER['HTTP_HOST'];
$port = $parsed_url['port'] ?? ($protocol === 'https' ? '443' : '80');

$user_info = [
    "username" => $user['username'], "password" => $user['password'], "message" => "Bem-vindo!", 
    "auth" => 1, "status" => "Active", "exp_date" => (string)$user['exp_date'], "is_trial" => (string)$user['is_trial'],
    "active_cons" => "0", "created_at" => (string)$user['created_at'], "max_connections" => "1", 
    "allowed_output_formats" => ["m3u8", "ts", "rtmp", "mp4"]
];

$server_info = [
    "url" => $host, "port" => (string)$port, "https_port" => "443", "server_protocol" => $protocol,
    "rtmp_port" => "8000", "timezone" => "America/Sao_Paulo", "timestamp_now" => time(), "time_now" => date('Y-m-d H:i:s')
];

if (empty($action)) { echo json_encode(["user_info" => $user_info, "server_info" => $server_info]); exit; }

// 3. LÓGICA DE BOUQUETS
$bouquets = json_decode($user['bouquet'] ?? '[]', true);
$allowed_streams = []; $allowed_series = [];
if (!empty($bouquets)) {
    $b_ids = implode(',', array_map('intval', $bouquets));
    $b_stmt = $pdo->query("SELECT bouquet_channels, bouquet_series FROM bouquets WHERE id IN ($b_ids)");
    while ($b = $b_stmt->fetch(PDO::FETCH_ASSOC)) {
        $c_arr = json_decode($b['bouquet_channels'], true); if (is_array($c_arr)) $allowed_streams = array_merge($allowed_streams, $c_arr);
        $s_arr = json_decode($b['bouquet_series'], true); if (is_array($s_arr)) $allowed_series = array_merge($allowed_series, $s_arr);
    }
    $allowed_streams = array_unique($allowed_streams); $allowed_series = array_unique($allowed_series);
}
$filter_streams = !empty($bouquets) ? " AND id IN (" . (empty($allowed_streams) ? '0' : implode(',', $allowed_streams)) . ")" : "";
$filter_series = !empty($bouquets) ? " AND id IN (" . (empty($allowed_series) ? '0' : implode(',', $allowed_series)) . ")" : "";

// 4. ROTAS DOS APLICATIVOS
switch ($action) {
    case 'get_live_categories':
        $stmt = $pdo->query("SELECT cast(id as char) as category_id, category_name, cast(parent_id as char) as parent_id FROM stream_categories WHERE category_type = 'live' ORDER BY cat_order ASC, category_name ASC");
        echo json_encode($stmt->fetchAll(PDO::FETCH_ASSOC)); break;
    case 'get_vod_categories':
        $stmt = $pdo->query("SELECT cast(id as char) as category_id, category_name, cast(parent_id as char) as parent_id FROM stream_categories WHERE category_type = 'movie' ORDER BY cat_order ASC, category_name ASC");
        echo json_encode($stmt->fetchAll(PDO::FETCH_ASSOC)); break;
    case 'get_series_categories':
        $stmt = $pdo->query("SELECT cast(id as char) as category_id, category_name, cast(parent_id as char) as parent_id FROM stream_categories WHERE category_type = 'series' ORDER BY cat_order ASC, category_name ASC");
        echo json_encode($stmt->fetchAll(PDO::FETCH_ASSOC)); break;

    case 'get_live_streams':
        $stmt = $pdo->query("SELECT id as num, stream_display_name as name, 'live' as stream_type, id as stream_id, stream_icon, '' as epg_channel_id, '0' as added, cast(category_id as char) as category_id, '' as custom_sid, 0 as tv_archive, '' as direct_source, 0 as tv_archive_duration FROM streams WHERE type = 1 $filter_streams");
        echo json_encode($stmt->fetchAll(PDO::FETCH_ASSOC)); break;
        
    case 'get_vod_streams':
        // Adicionado 'rating' e 'rating_5based' para o XCIPTV ler corretamente os filmes
        $stmt = $pdo->query("SELECT id as num, stream_display_name as name, 'movie' as stream_type, id as stream_id, stream_icon, 0 as rating, 0 as rating_5based, '0' as added, cast(category_id as char) as category_id, target_container as container_extension, '' as custom_sid, '' as direct_source FROM streams WHERE type = 2 $filter_streams");
        echo json_encode($stmt->fetchAll(PDO::FETCH_ASSOC)); break;
        
    case 'get_series':
        $stmt = $pdo->query("SELECT id as num, title as name, CAST(id AS CHAR) as series_id, cover, plot, '' as cast, '' as director, '' as genre, releaseDate, '0' as last_modified, '' as rating, 0 as rating_5based, CAST(category_id AS CHAR) as category_id, '' as youtube_trailer, '' as episode_run_time, cover as backdrop_path FROM series WHERE 1=1 $filter_series");
        echo json_encode($stmt->fetchAll(PDO::FETCH_ASSOC)); break;

    // === NOVO: INFORMAÇÕES DE FILME COM PADRÃO EXATO DO XCIPTV E SMARTERS ===
    case 'get_vod_info':
        $vod_id = (int)($_GET['vod_id'] ?? 0);
        $stmt = $pdo->prepare("SELECT stream_display_name as name, stream_icon, movie_propeties, target_container as container_extension, category_id FROM streams WHERE id = ? AND type = 2");
        $stmt->execute([$vod_id]);
        $vod = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($vod) {
            $prop = json_decode($vod['movie_propeties'], true) ?: [];
            $img = !empty($prop['movie_image']) ? $prop['movie_image'] : $vod['stream_icon'];
            $plot = $prop['plot'] ?? '';

            // O aplicativo precisa de todas essas chaves preenchidas para desenhar a tela
            $info = [
                "kinopoisk_url" => "", 
                "tmdb_id" => "",
                "name" => $vod['name'], 
                "o_name" => $vod['name'],
                "cover_big" => $img, // Smarters usa esse
                "movie_image" => $img, // XCIPTV usa esse
                "releasedate" => "", 
                "episode_run_time" => "", 
                "youtube_trailer" => "",
                "director" => "", 
                "actors" => "", 
                "cast" => "",
                "description" => $plot, // Smarters usa esse
                "plot" => $plot, // XCIPTV usa esse
                "age" => "", 
                "mpaa_rating" => "", 
                "rating_count_kinopoisk" => 0,
                "country" => "", 
                "genre" => "",
                "backdrop_path" => [$img],
                "duration_secs" => 0, 
                "duration" => "00:00:00",
                "bitrate" => 0, 
                "rating" => "0"
            ];

            $movie_data = [
                "stream_id" => $vod_id,
                "name" => $vod['name'], 
                "title" => $vod['name'],
                "year" => "", 
                "added" => "0",
                "category_id" => (string)$vod['category_id'],
                "container_extension" => $vod['container_extension'] ?: "mp4",
                "custom_sid" => "", 
                "direct_source" => ""
            ];

            echo json_encode(["info" => $info, "movie_data" => $movie_data], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
        } else {
            echo json_encode([]);
        }
        break;

    // === INFORMAÇÕES DA SÉRIE E EPISÓDIOS ===
    case 'get_series_info':
        $series_id = (int)($_GET['series_id'] ?? 0);
        $stmtS = $pdo->prepare("SELECT title as name, cover, plot, releaseDate, cast(category_id as char) as category_id FROM series WHERE id = ?");
        $stmtS->execute([$series_id]); $serie = $stmtS->fetch(PDO::FETCH_ASSOC);
        if (!$serie) { echo json_encode([]); exit; }

        $stmtE = $pdo->prepare("SELECT id, stream_display_name, stream_icon, target_container, movie_propeties FROM streams WHERE type = 5 AND series_no = ?");
        $stmtE->execute([$series_id]); $episodios = $stmtE->fetchAll(PDO::FETCH_ASSOC);

        $eps_formatados = new stdClass(); $seasons_array = []; $season_added = [];
        foreach ($episodios as $ep) {
            $prop = json_decode($ep['movie_propeties'], true) ?: [];
            $s = isset($prop['season']) ? (int)$prop['season'] : 1;
            $e = isset($prop['episode']) ? (int)$prop['episode'] : 1;
            $s_str = (string)$s;

            if (!in_array($s, $season_added)) {
                $seasons_array[] = ["air_date" => "", "episode_count" => 1, "id" => $s, "name" => "Temporada " . $s, "overview" => "", "season_number" => $s, "cover" => $serie['cover'], "cover_big" => $serie['cover']];
                $season_added[] = $s;
            }
            if (!isset($eps_formatados->$s_str)) { $eps_formatados->$s_str = []; }
            
            $eps_formatados->$s_str[] = ["id" => (string)$ep['id'], "episode_num" => (string)$e, "title" => $ep['stream_display_name'], "container_extension" => $ep['target_container'] ?: "mp4", "info" => [ "plot" => $prop['plot'] ?? '', "cover" => $ep['stream_icon'] ?: $serie['cover'] ], "custom_sid" => "", "added" => "0", "season" => (string)$s, "direct_source" => ""];
        }

        $serie['cast'] = ""; $serie['director'] = ""; $serie['genre'] = ""; $serie['last_modified'] = "0"; $serie['rating'] = ""; $serie['youtube_trailer'] = ""; $serie['episode_run_time'] = ""; $serie['backdrop_path'] = $serie['cover'];
        echo json_encode(["seasons" => $seasons_array, "info" => $serie, "episodes" => $eps_formatados], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
        break;
        
    default: echo json_encode([]); break;
}
?>
